<?php
// D:\wamp64\www\shtaller-gk\ver_tutorial.php
session_start();
include 'includes/db.php';
include 'includes/header.php';

$archivo = 'TUTORIAL_MAESTRO.md';

// Verificamos si el archivo existe
if (!file_exists($archivo)) {
    echo "<div class='container mt-5 alert alert-danger'>Error: No se encontró el archivo $archivo</div>";
    include 'includes/footer.php';
    exit;
}

$contenido = file_get_contents($archivo);

// Función simple para convertir Markdown básico a HTML sin librerías externas
function markdown_to_html($text) {
    // Títulos
    $text = preg_replace('/^### (.*$)/m', '<h5 class="text-indigo mt-4">$1</h5>', $text);
    $text = preg_replace('/^## (.*$)/m', '<h3 class="border-bottom pb-2 mt-5">$1</h3>', $text);
    $text = preg_replace('/^# (.*$)/m', '<h1 class="display-5 fw-bold text-center mb-4">$1</h1>', $text);
    // Negritas
    $text = preg_replace('/\*\*(.*)\*\*/U', '<strong>$1</strong>', $text);
    // Listas
    $text = preg_replace('/^\* (.*$)/m', '<li>$1</li>', $text);
    $text = preg_replace('/(<li>.*<\/li>)/s', '<ul class="list-tutorial">$1</ul>', $text);
    // Saltos de línea
    $text = nl2br($text);
    return $text;
}
?>

<style>
    .tutorial-container { background: #fff; min-height: 100vh; padding: 50px; border-radius: 15px; border: 1px solid #e0e0e0; }
    .text-indigo { color: #5d50c6; font-weight: 700; }
    .list-tutorial { margin-bottom: 20px; padding-left: 20px; }
    .list-tutorial li { margin-bottom: 10px; position: relative; list-style: none; }
    .list-tutorial li::before { content: "\f058"; font-family: "Font Awesome 5 Free"; font-weight: 900; color: #5d50c6; position: absolute; left: -25px; }
    .badge-soft { background: #eeecfb; color: #5d50c6; padding: 5px 12px; border-radius: 20px; font-weight: 600; font-size: 0.8rem; }
    .btn-print { position: fixed; bottom: 30px; right: 30px; border-radius: 50px; padding: 15px 25px; box-shadow: 0 10px 20px rgba(93, 80, 198, 0.3); }
    
    @media print { .btn-print, .sidebar, .header-nav { display: none !important; } .tutorial-container { border: none; padding: 0; } }
</style>

<div class="container py-5">
    <div class="tutorial-container shadow-sm">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <span class="badge-soft">Documentación Técnica v2.0</span>
            <span class="text-muted small">Última actualización: <?= date("d/m/Y", filemtime($archivo)) ?></span>
        </div>

        <div class="markdown-body">
            <?= markdown_to_html($contenido) ?>
        </div>
    </div>
</div>

<button class="btn btn-indigo btn-print text-white" onclick="window.print()">
    <i class="fas fa-print me-2"></i> Imprimir Manual A4
</button>

<?php include 'includes/footer.php'; ?>