<?php
include 'includes/header.php';

// Habilitar errores para diagnóstico
ini_set('display_errors', 1);
error_reporting(E_ALL);

$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
$cat = isset($_GET['categoria']) ? strtolower($_GET['categoria']) : '';

if (!$id || !$cat) {
    die("<div class='p-4 alert alert-danger'>Error: Parámetros de orden o categoría insuficientes.</div>");
}

// Mapeo de tablas
$tablas = [
    'frenos' => 'ordenes_frenos',
    'motor' => 'ordenes_motor',
    'suspension' => 'ordenes_suspension',
    'otros' => 'ordenes_otros'
];

$tabla = $tablas[$cat] ?? die("<div class='p-4 alert alert-danger'>Categoría inválida.</div>");

try {
    // Consulta SQL con el nombre de columna correcto: nombres_apellido
    $sql = "SELECT o.*, c.nombres_apellido 
            FROM $tabla o 
            LEFT JOIN clientes c ON o.cliente_id = c.id 
            WHERE o.id = ?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$id]);
    $orden = $stmt->fetch(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    die("<div class='p-4 alert alert-danger'>Error de base de datos: " . $e->getMessage() . "</div>");
}

if (!$orden) {
    die("<div class='p-4 alert alert-warning'>Error: No se encontró la orden solicitada.</div>");
}

// --- PROCESAMIENTO DE ÍTEMS Y SUMA DE TOTAL ---
$items = json_decode($orden['detalles_items'] ?? '[]', true);
$total_calculado = 0;
?>

<div class="no-print p-3 bg-light border-bottom d-flex justify-content-between align-items-center">
    <a href="ordenes.php" class="btn btn-secondary btn-sm"><i class="fas fa-arrow-left"></i> Volver</a>
    <div class="d-flex gap-2">
        <button onclick="window.print()" class="btn btn-primary"><i class="fas fa-print"></i> Imprimir</button>
        <button onclick="exportToExcel()" class="btn btn-success"><i class="fas fa-file-excel"></i> Excel</button>
    </div>
</div>

<div class="print-container p-4 bg-white shadow-sm mx-auto" style="max-width: 900px;">
    <div class="text-center mb-4">
        <h1 class="fw-bold m-0" style="font-size: 2.8rem;"><?= htmlspecialchars($config['nombre_taller'] ?? 'Taller Alberto') ?></h1>
        <h4 class="text-uppercase border-bottom border-2 d-inline-block px-4 pb-1">Orden de Trabajo: <?= strtoupper($cat) ?></h4>
    </div>

    <table class="table table-bordered mb-4 border-dark">
        <thead class="bg-light">
            <tr>
                <th width="35%">CLIENTE</th>
                <th width="15%">FECHA</th>
                <th width="25%">VEHÍCULO</th>
                <th width="15%">PATENTE</th>
                <th width="10%">KMS</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td><?= htmlspecialchars($orden['nombres_apellido'] ?? 'S/D') ?></td>
                <td><?= date('d/m/Y', strtotime($orden['fecha'])) ?></td>
                <td><?= htmlspecialchars($orden['vehiculo']) ?></td>
                <td><?= htmlspecialchars($orden['patente']) ?></td>
                <td><?= htmlspecialchars($orden['kms']) ?></td>
            </tr>
        </tbody>
    </table>

    <table class="table table-bordered border-dark" id="tabla-items-ver">
        <thead class="table-dark">
            <tr>
                <th>DESCRIPCIÓN DE TRABAJO / REPUESTO</th>
                <th width="100" class="text-center">REALIZADO</th>
                <th width="150" class="text-end">IMPORTE ($)</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($items as $item): 
                // Sumamos el precio de cada ítem al total acumulado
                $precio = floatval($item['precio'] ?? 0);
                $total_calculado += $precio;
            ?>
                <tr>
                    <td><?= htmlspecialchars($item['descripcion']) ?></td>
                    <td class="text-center fw-bold"><?= ($item['realizado'] == 'SI' || $item['realizado'] == 1) ? '✓' : '-' ?></td>
                    <td class="text-end"><?= number_format($precio, 2, ',', '.') ?></td>
                </tr>
            <?php endforeach; ?>
            
            <?php for($i = 0; $i < 4; $i++): ?>
                <tr><td height="30">&nbsp;</td><td></td><td></td></tr>
            <?php endfor; ?>
        </tbody>
        <tfoot>
            <tr class="bg-light">
                <td colspan="2" class="text-end fw-bold align-middle" style="font-size: 1.3rem;">TOTAL A PAGAR:</td>
                <td class="text-end fw-bold align-middle text-danger" style="font-size: 1.6rem;">
                    $<?= number_format($total_calculado, 2, ',', '.') ?>
                </td>
            </tr>
        </tfoot>
    </table>
</div>

<style>
    @media print {
        @page { size: A4; margin: 10mm; }
        .no-print { display: none !important; }
        .print-container { width: 100% !important; padding: 0 !important; border: none !important; box-shadow: none !important; }
        table { border: 1px solid #000 !important; }
        th, td { border: 1px solid #000 !important; }
    }
</style>

<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
<script>
    function exportToExcel() {
        let wb = XLSX.utils.book_new();
        let ws_data = [
            ["ORDEN DE TRABAJO: <?= strtoupper($cat) ?> - N° <?= $id ?>"],
            ["Taller: <?= $config['nombre_taller'] ?? 'Alberto' ?>"],
            [""],
            ["Cliente:", "<?= $orden['nombres_apellido'] ?>", "Fecha:", "<?= date('d/m/Y', strtotime($orden['fecha'])) ?>"],
            ["Vehículo:", "<?= $orden['vehiculo'] ?>", "Patente:", "<?= $orden['patente'] ?>"],
            [""],
            ["DETALLE", "REALIZADO", "PRECIO ($)"]
        ];

        <?php foreach ($items as $item): ?>
            ws_data.push(["<?= $item['descripcion'] ?>", "<?= ($item['realizado'] == 'SI' || $item['realizado'] == 1) ? 'SI' : 'NO' ?>", "<?= $item['precio'] ?>"]);
        <?php endforeach; ?>

        ws_data.push(["", "TOTAL:", "<?= $total_calculado ?>"]);

        let ws = XLSX.utils.aoa_to_sheet(ws_data);
        XLSX.utils.book_append_sheet(wb, ws, "DetalleOrden");
        XLSX.writeFile(wb, "Orden_<?= $id ?>_Taller.xlsx");
    }
</script>

<?php include 'includes/footer.php'; ?>