<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}
include 'includes/db.php';
include 'includes/header.php';

// Obtener listado de vehículos con datos del cliente
$sql = "SELECT v.*, c.nombres_apellido 
        FROM vehiculos v 
        LEFT JOIN clientes c ON v.cliente_id = c.id 
        ORDER BY v.fecha_actualizacion DESC";
$stmt = $pdo->query($sql);
$vehiculos = $stmt->fetchAll();
?>

<div class="p-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="fw-bold text-dark m-0">
            <i class="fas fa-car me-2" style="color: #5d50c6;"></i> Gestión de Vehículos
        </h3>
        <button class="btn btn-primary px-4 fw-bold shadow-sm" data-bs-toggle="modal"
            data-bs-target="#modalNuevoVehiculo">
            <i class="fas fa-plus-circle me-1"></i> NUEVO VEHÍCULO
        </button>
    </div>

    <?php if (isset($_GET['msg'])): ?>
        <div class="alert alert-<?= $_GET['status'] == 'success' ? 'success' : 'danger' ?> alert-dismissible fade show"
            role="alert">
            <?= htmlspecialchars($_GET['msg']) ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <div class="card shadow-sm border-0 rounded-4">
        <div class="card-body p-0">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead class="bg-light">
                        <tr class="text-uppercase small fw-bold text-muted">
                            <th class="px-4">ID</th>
                            <th>Cliente</th>
                            <th>Patente</th>
                            <th>Marca/Modelo</th>
                            <th>Año</th>
                            <th>Kms Actual</th>
                            <th class="text-end">Fecha Actualización</th>
                            <th class="text-end px-4">Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (count($vehiculos) > 0): ?>
                            <?php foreach ($vehiculos as $v): ?>
                                <tr>
                                    <td class="px-4 fw-bold text-muted">#<?= $v['id'] ?></td>
                                    <td class="fw-bold">
                                        <?php if ($v['nombres_apellido']): ?>
                                            <a href="clientes.php?search=<?= urlencode($v['nombres_apellido']) ?>"
                                                class="text-decoration-none text-dark">
                                                <?= htmlspecialchars($v['nombres_apellido'] ?? '') ?>
                                            </a>
                                        <?php else: ?>
                                            <span class="text-muted fst-italic">Sin Cliente</span>
                                        <?php endif; ?>
                                    </td>
                                    <td><span
                                            class="badge bg-light text-dark border border-secondary"><?= htmlspecialchars($v['patente'] ?? '') ?></span>
                                    </td>
                                    <td><?= htmlspecialchars($v['marca_modelo'] ?? '') ?></td>
                                    <td><?= $v['anio'] ? htmlspecialchars($v['anio']) : '-' ?></td>
                                    <td class="font-monospace fw-bold text-primary">
                                        <?= number_format((float) $v['ultimo_kms'], 0, ',', '.') ?> km
                                    </td>
                                    <td class="text-end"><small
                                            class="text-muted"><?= date('d/m/Y H:i', strtotime($v['fecha_actualizacion'])) ?></small>
                                    </td>
                                    <td class="text-end px-4">
                                        <button class="btn btn-sm btn-outline-primary"
                                            onclick='editarVehiculo(<?= json_encode($v) ?>)'>
                                            <i class="fas fa-edit"></i>
                                        </button>
                                        <button class="btn btn-sm btn-outline-danger ms-1"
                                            onclick="eliminarVehiculo(<?= $v['id'] ?>)">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="8" class="text-center py-5 text-muted">
                                    <i class="fas fa-car fa-3x mb-3 text-secondary opacity-50"></i>
                                    <p class="mb-0">No hay vehículos registrados aún.</p>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Modal Nuevo Vehículo -->
<!-- Modal Nuevo Vehículo movido a includes/modals_globales.php -->

<!-- Modal Editar Vehículo -->
<!-- Modal Editar Vehículo movido a includes/modals_globales.php -->

<!-- Modal Eliminar Form -->
<!-- Modal Eliminar movido a includes/modals_globales.php -->

<!-- Modal Cliente Express (Simplificado del original o reutilizandolo) -->
<!-- Reutilizamos el modal #modalNuevo de 'footer.php' pero le cambiamos el comportamiento al guardar -->
<script>
    function editarVehiculo(v) {
        document.getElementById('edit_v_id').value = v.id;
        document.getElementById('edit_v_patente').value = v.patente;
        document.getElementById('edit_v_modelo').value = v.marca_modelo;
        document.getElementById('edit_v_anio').value = v.anio;
        document.getElementById('edit_v_kms').value = v.ultimo_kms;
        document.getElementById('edit_v_cliente').value = v.cliente_id;
        new bootstrap.Modal(document.getElementById('modalEditarVehiculo')).show();
    }

    function eliminarVehiculo(id) {
        if (confirm('¿Está seguro de eliminar este vehículo?')) {
            document.getElementById('del_v_id').value = id;
            document.getElementById('formEliminarVehiculo').submit();
        }
    }

    function abrirModalClienteExpress() {
        // Abrimos el modal existente en footer.php
        const modalEl = document.getElementById('modalNuevo');
        const modal = new bootstrap.Modal(modalEl);

        // Interceptamos el submit SOLAMENTE para esta sesión/instancia
        const form = modalEl.querySelector('form');

        // Quitamos listeners anteriores para no duplicar (si fuera posible, pero cloneNode es drástico)
        // Usamos una bandera o un manejador específico
        form.onsubmit = function (e) {
            e.preventDefault();
            const formData = new FormData(form);
            formData.append('ajax', '1'); // Forzar respuesta JSON

            fetch('procesar_cliente.php', {
                method: 'POST',
                body: formData
            })
                .then(res => res.json())
                .then(data => {
                    if (data.status === 'ok') {
                        alert(data.message);
                        // Agregar al select y seleccionar
                        const select = document.getElementById('select_cliente_nuevo');
                        const option = new Option(data.data.nombres_apellido, data.data.id, true, true);
                        select.add(option);

                        // Cerrar modal cliente
                        modal.hide();

                        // Asegurar que volvemos al modal vehículo (si se cerró por backdrop)
                        // new bootstrap.Modal(document.getElementById('modalNuevoVehiculo')).show();

                        // Limpiar formulario cliente
                        form.reset();
                        form.onsubmit = null; // Restaurar comportamiento
                    } else {
                        alert('Error: ' + data.message);
                    }
                })
                .catch(err => {
                    console.error(err);
                    alert('Ocurrió un error al guardar el cliente.');
                });
        };

        modal.show();
    }
</script>

<?php include 'includes/footer.php'; ?>