<?php
// test_integration.php
// Script de prueba para verificar la integración Cliente -> Vehículo -> Busqueda

include 'includes/db.php';

echo "<h2>Test de Integración de Backend</h2>";

// 1. Simular creación de cliente + vehículo
echo "<h3>1. Creando Cliente de Prueba...</h3>";
$testName = "Cliente Test " . uniqid();
$testPatente = "TEST" . rand(100, 999);
$testModelo = "Modelo Test";

$_POST = [
    'accion' => 'nuevo',
    'nombres_apellido' => $testName,
    'cuit_dni' => '12345678',
    'vehiculo_modelo' => $testModelo,
    'patente' => $testPatente,
    'ajax' => '1' // Simulamos ajax para capturar output json
];

// Capturamos la salida de procesar_cliente.php
ob_start();
include 'procesar_cliente.php';
$output = ob_get_clean();
$json = json_decode($output, true);

if ($json && $json['status'] == 'ok') {
    echo "<p style='color:green'>Cliente creado con ID: " . $json['data']['id'] . "</p>";
    $clienteId = $json['data']['id'];

    // 2. Verificar si se creó el vehículo
    echo "<h3>2. Verificando tabla Vehículos...</h3>";
    $stmtV = $pdo->prepare("SELECT * FROM vehiculos WHERE patente = ?");
    $stmtV->execute([$testPatente]);
    $vehiculo = $stmtV->fetch(PDO::FETCH_ASSOC);

    if ($vehiculo) {
        echo "<p style='color:green'>Vehículo ENCONTRADO en BD.</p>";
        echo "<ul>";
        echo "<li>Patente: " . $vehiculo['patente'] . "</li>";
        echo "<li>Modelo: " . $vehiculo['marca_modelo'] . "</li>";
        echo "<li>Cliente ID: " . $vehiculo['cliente_id'] . " (Esperado: $clienteId)</li>";
        echo "</ul>";

        if ($vehiculo['cliente_id'] == $clienteId) {
            echo "<p style='color:green'><strong>CORRECTO: El vehículo está vinculado al cliente.</strong></p>";
        } else {
            echo "<p style='color:red'><strong>ERROR: ID de cliente no coincide.</strong></p>";
        }

        // 3. Verificar Búsqueda
        echo "<h3>3. Verificando Búsqueda (buscar_patente.php)...</h3>";

        // Test por Patente
        $_GET['term'] = $testPatente;
        ob_start();
        include 'buscar_patente.php';
        $searchOut = ob_get_clean();
        $res = json_decode($searchOut, true);

        if (count($res) > 0 && $res[0]['patente'] == $testPatente) {
            echo "<p style='color:green'>Búsqueda por PATENTE: OK</p>";
        } else {
            echo "<p style='color:red'>Búsqueda por PATENTE: FALLÓ</p>";
        }

        // Test por Modelo
        $_GET['term'] = "Modelo Test";
        ob_start();
        include 'buscar_patente.php';
        $searchOut2 = ob_get_clean();
        $res2 = json_decode($searchOut2, true);

        // Puede haber multiples, buscamos el nuestro
        $found = false;
        foreach ($res2 as $r) {
            if ($r['patente'] == $testPatente)
                $found = true;
        }

        if ($found) {
            echo "<p style='color:green'>Búsqueda por MODELO: OK</p>";
        } else {
            echo "<p style='color:red'>Búsqueda por MODELO: FALLÓ</p>";
        }

    } else {
        echo "<p style='color:red'><strong>ERROR: Vehículo NO se guardó en la tabla vehiculos.</strong></p>";
    }

} else {
    echo "<p style='color:red'>Error creando cliente: " . $output . "</p>";
}

// Limpieza (Opcional, comentado para poder verificar manualmente si se desea)
/*
$pdo->exec("DELETE FROM  vehiculos WHERE patente = '$testPatente'");
$pdo->exec("DELETE FROM clientes WHERE id = $clienteId");
*/
?>