-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1:3306
-- Generation Time: Feb 16, 2026 at 05:35 AM
-- Server version: 9.1.0
-- PHP Version: 8.3.14

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `shtaller-gk`
--

-- --------------------------------------------------------

--
-- Table structure for table `clientes`
--

DROP TABLE IF EXISTS `clientes`;
CREATE TABLE IF NOT EXISTS `clientes` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nombres_apellido` varchar(150) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `cuit_dni` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `celular` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `domicilio` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `ciudad` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `vehiculo_modelo` varchar(150) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `patente` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `clientes`
--

INSERT INTO `clientes` (`id`, `nombres_apellido`, `cuit_dni`, `celular`, `domicilio`, `ciudad`, `vehiculo_modelo`, `patente`) VALUES
(16, 'Juan Perez', '25888999', '2995777888', 'Belgrano 237', 'Neuquen', 'Ford Fiesta', ''),
(17, 'Carlos Lobos', '12555888', '155444888', 'San luis 333', 'Neuquen', 'Fiat palio', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `configuracion`
--

DROP TABLE IF EXISTS `configuracion`;
CREATE TABLE IF NOT EXISTS `configuracion` (
  `id` int NOT NULL DEFAULT '1',
  `nombre_taller` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `cuit` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `iva_condicion` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `domicilio` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `telefono` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `email` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `logo_path` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `configuracion`
--

INSERT INTO `configuracion` (`id`, `nombre_taller`, `cuit`, `iva_condicion`, `domicilio`, `telefono`, `email`, `logo_path`) VALUES
(1, 'Taller Automotor', '20-123456789-1', 'Responsable Inscripto', '', '555588899', '', 'assets/img/logo_taller.png');

-- --------------------------------------------------------

--
-- Table structure for table `gastos`
--

DROP TABLE IF EXISTS `gastos`;
CREATE TABLE IF NOT EXISTS `gastos` (
  `id` int NOT NULL AUTO_INCREMENT,
  `categoria` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `numero_factura` varchar(50) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `descripcion` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci,
  `monto` decimal(10,2) NOT NULL DEFAULT '0.00',
  `fecha` datetime DEFAULT CURRENT_TIMESTAMP,
  `comprobante` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `gastos`
--

INSERT INTO `gastos` (`id`, `categoria`, `numero_factura`, `descripcion`, `monto`, `fecha`, `comprobante`) VALUES
(1, 'Servicios', '001223456', 'Luz diciembre 2025', 105000.00, '2026-01-27 00:00:00', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `ordenes`
--

DROP TABLE IF EXISTS `ordenes`;
CREATE TABLE IF NOT EXISTS `ordenes` (
  `id` int NOT NULL AUTO_INCREMENT,
  `cliente_id` int NOT NULL,
  `tipo_orden` varchar(50) COLLATE utf8mb4_general_ci DEFAULT 'frenos',
  `fecha` date NOT NULL,
  `total_monto` decimal(10,2) NOT NULL,
  `notas` text COLLATE utf8mb4_general_ci,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ordenes_detalles`
--

DROP TABLE IF EXISTS `ordenes_detalles`;
CREATE TABLE IF NOT EXISTS `ordenes_detalles` (
  `id` int NOT NULL AUTO_INCREMENT,
  `orden_id` int DEFAULT NULL,
  `nombre_item` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `precio` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `orden_id` (`orden_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ordenes_frenos`
--

DROP TABLE IF EXISTS `ordenes_frenos`;
CREATE TABLE IF NOT EXISTS `ordenes_frenos` (
  `id` int NOT NULL AUTO_INCREMENT,
  `orden_num` int DEFAULT NULL,
  `cliente_id` int DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `vehiculo` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `patente` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `kms` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `detalles_items` json DEFAULT NULL,
  `subtotal_1` decimal(10,2) DEFAULT NULL,
  `subtotal_2` decimal(10,2) DEFAULT NULL,
  `total` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `orden_num` (`orden_num`),
  KEY `cliente_id` (`cliente_id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ordenes_items`
--

DROP TABLE IF EXISTS `ordenes_items`;
CREATE TABLE IF NOT EXISTS `ordenes_items` (
  `id` int NOT NULL AUTO_INCREMENT,
  `orden_id` int NOT NULL,
  `descripcion` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `precio` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `orden_id` (`orden_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ordenes_motor`
--

DROP TABLE IF EXISTS `ordenes_motor`;
CREATE TABLE IF NOT EXISTS `ordenes_motor` (
  `id` int NOT NULL AUTO_INCREMENT,
  `orden_num` int DEFAULT NULL,
  `cliente_id` int DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `vehiculo` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `patente` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `kms` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `detalles_items` json DEFAULT NULL,
  `subtotal_1` decimal(10,2) DEFAULT NULL,
  `subtotal_2` decimal(10,2) DEFAULT NULL,
  `total` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `orden_num` (`orden_num`),
  KEY `cliente_id` (`cliente_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ordenes_otros`
--

DROP TABLE IF EXISTS `ordenes_otros`;
CREATE TABLE IF NOT EXISTS `ordenes_otros` (
  `id` int NOT NULL AUTO_INCREMENT,
  `orden_num` int DEFAULT NULL,
  `cliente_id` int DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `vehiculo` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `patente` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `kms` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `trabajos_realizados` text COLLATE utf8mb4_general_ci,
  `observaciones` text COLLATE utf8mb4_general_ci,
  `total` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `orden_num` (`orden_num`),
  KEY `cliente_id` (`cliente_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ordenes_suspension`
--

DROP TABLE IF EXISTS `ordenes_suspension`;
CREATE TABLE IF NOT EXISTS `ordenes_suspension` (
  `id` int NOT NULL AUTO_INCREMENT,
  `orden_num` int DEFAULT NULL,
  `cliente_id` int DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `vehiculo` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `patente` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `kms` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `detalles_items` json DEFAULT NULL,
  `subtotal_1` decimal(10,2) DEFAULT NULL,
  `subtotal_2` decimal(10,2) DEFAULT NULL,
  `total` decimal(10,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `orden_num` (`orden_num`),
  KEY `cliente_id` (`cliente_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ordenes_trabajo`
--

DROP TABLE IF EXISTS `ordenes_trabajo`;
CREATE TABLE IF NOT EXISTS `ordenes_trabajo` (
  `id` int NOT NULL AUTO_INCREMENT,
  `cliente_id` int NOT NULL,
  `tipo_seccion` varchar(50) DEFAULT NULL,
  `fecha` date DEFAULT NULL,
  `vehiculo` varchar(150) DEFAULT NULL,
  `patente` varchar(20) DEFAULT NULL,
  `kms` varchar(20) DEFAULT NULL,
  `total_final` decimal(10,2) DEFAULT NULL,
  `observaciones` text,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `turnos`
--

DROP TABLE IF EXISTS `turnos`;
CREATE TABLE IF NOT EXISTS `turnos` (
  `id` int NOT NULL AUTO_INCREMENT,
  `cliente_id` int DEFAULT NULL,
  `nombres_apellido` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `fecha_turno` datetime DEFAULT NULL,
  `motivo` varchar(255) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `vehiculo_modelo` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `patente` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `estado` enum('Pendiente','Confirmado','En Taller','Finalizado','Cancelado') COLLATE utf8mb4_general_ci DEFAULT 'Pendiente',
  PRIMARY KEY (`id`),
  KEY `cliente_id` (`cliente_id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `usuarios`
--

DROP TABLE IF EXISTS `usuarios`;
CREATE TABLE IF NOT EXISTS `usuarios` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nombres` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `apellidos` varchar(100) COLLATE utf8mb4_general_ci DEFAULT NULL,
  `usuario` varchar(50) COLLATE utf8mb4_general_ci NOT NULL,
  `password` varchar(255) COLLATE utf8mb4_general_ci NOT NULL,
  `rol` varchar(20) COLLATE utf8mb4_general_ci DEFAULT 'mecanico',
  `estado` tinyint(1) DEFAULT '1' COMMENT '1: Activo, 0: Inactivo',
  PRIMARY KEY (`id`),
  UNIQUE KEY `usuario` (`usuario`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `usuarios`
--

INSERT INTO `usuarios` (`id`, `nombres`, `apellidos`, `usuario`, `password`, `rol`, `estado`) VALUES
(1, 'Administrador', 'General', 'admin', '$2y$10$qo.0nmGJGxninq8qWapfduQyQ8YHucFGBjZ.79T5CuLZf8CPf93Sq', 'admin', 1),
(3, 'Alberto', 'NoLoSe', 'alberto', '$2y$10$G8jNciwCslqcNnk4COfCj.8usgh5I9NGrS7RKjfbi6oTGw96kHy0m', 'mecanico', 1),
(4, NULL, NULL, 'juan', '$2y$10$9RYiVj/07h1TP/iG/vnecu7Hjm9ZjzxIfxkYncMTBOIZjz/fNmt.S', 'mecanico', 0);

-- --------------------------------------------------------

--
-- Table structure for table `vehiculos`
--

DROP TABLE IF EXISTS `vehiculos`;
CREATE TABLE IF NOT EXISTS `vehiculos` (
  `id` int NOT NULL AUTO_INCREMENT,
  `cliente_id` int NOT NULL,
  `patente` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `marca_modelo` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `anio` int DEFAULT NULL,
  `ultimo_kms` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `fecha_actualizacion` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `patente` (`patente`),
  KEY `cliente_id` (`cliente_id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `vehiculos`
--

INSERT INTO `vehiculos` (`id`, `cliente_id`, `patente`, `marca_modelo`, `anio`, `ultimo_kms`, `fecha_actualizacion`) VALUES
(7, 16, 'HGH357', 'Ford Fiesta', 2018, '85600', '2026-02-14 06:05:40'),
(8, 16, 'RRHH789', 'Reanul Kangoo', 2019, '96444', '2026-02-14 06:10:43'),
(9, 17, 'LLJ852', 'Fiat palio', NULL, '0', '2026-02-14 08:22:41');

-- --------------------------------------------------------

--
-- Stand-in structure for view `view_historial_global`
-- (See below for the actual view)
--
DROP VIEW IF EXISTS `view_historial_global`;
CREATE TABLE IF NOT EXISTS `view_historial_global` (
`cliente_id` int
,`detalles` json
,`fecha` date
,`kms` varchar(20)
,`orden_id` int
,`orden_num` int
,`patente` varchar(20)
,`tipo` varchar(10)
,`total` decimal(10,2)
,`vehiculo` varchar(100)
);

-- --------------------------------------------------------

--
-- Structure for view `view_historial_global`
--
DROP TABLE IF EXISTS `view_historial_global`;

DROP VIEW IF EXISTS `view_historial_global`;
CREATE VIEW `view_historial_global`  AS SELECT `ordenes_frenos`.`id` AS `orden_id`, 'Frenos' AS `tipo`, `ordenes_frenos`.`cliente_id` AS `cliente_id`, `ordenes_frenos`.`fecha` AS `fecha`, `ordenes_frenos`.`vehiculo` AS `vehiculo`, `ordenes_frenos`.`patente` AS `patente`, `ordenes_frenos`.`kms` AS `kms`, `ordenes_frenos`.`total` AS `total`, `ordenes_frenos`.`orden_num` AS `orden_num`, `ordenes_frenos`.`detalles_items` AS `detalles` FROM `ordenes_frenos`union all select `ordenes_motor`.`id` AS `orden_id`,'Motor' AS `tipo`,`ordenes_motor`.`cliente_id` AS `cliente_id`,`ordenes_motor`.`fecha` AS `fecha`,`ordenes_motor`.`vehiculo` AS `vehiculo`,`ordenes_motor`.`patente` AS `patente`,`ordenes_motor`.`kms` AS `kms`,`ordenes_motor`.`total` AS `total`,`ordenes_motor`.`orden_num` AS `orden_num`,`ordenes_motor`.`detalles_items` AS `detalles` from `ordenes_motor` union all select `ordenes_suspension`.`id` AS `orden_id`,'Suspensión' AS `tipo`,`ordenes_suspension`.`cliente_id` AS `cliente_id`,`ordenes_suspension`.`fecha` AS `fecha`,`ordenes_suspension`.`vehiculo` AS `vehiculo`,`ordenes_suspension`.`patente` AS `patente`,`ordenes_suspension`.`kms` AS `kms`,`ordenes_suspension`.`total` AS `total`,`ordenes_suspension`.`orden_num` AS `orden_num`,`ordenes_suspension`.`detalles_items` AS `detalles` from `ordenes_suspension` union all select `ordenes_otros`.`id` AS `orden_id`,'Otros' AS `tipo`,`ordenes_otros`.`cliente_id` AS `cliente_id`,`ordenes_otros`.`fecha` AS `fecha`,`ordenes_otros`.`vehiculo` AS `vehiculo`,`ordenes_otros`.`patente` AS `patente`,`ordenes_otros`.`kms` AS `kms`,`ordenes_otros`.`total` AS `total`,`ordenes_otros`.`orden_num` AS `orden_num`,NULL AS `detalles` from `ordenes_otros`  ;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
