<?php
// scripts/setup_vehiculos.php
// Este script crea la tabla 'vehiculos' y migra los datos existentes de las ordenes.

require_once __DIR__ . '/includes/db.php';

echo "Iniciando configuración de tabla 'vehiculos'...\n";

try {
    // 1. Crear tabla vehiculos
    $sqlCreate = "
    CREATE TABLE IF NOT EXISTS `vehiculos` (
      `id` int(11) NOT NULL AUTO_INCREMENT,
      `cliente_id` int(11) NOT NULL,
      `patente` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
      `marca_modelo` varchar(150) COLLATE utf8mb4_general_ci DEFAULT NULL,
      `anio` int(4) DEFAULT NULL,
      `ultimo_kms` varchar(20) COLLATE utf8mb4_general_ci DEFAULT NULL,
      `fecha_actualizacion` datetime DEFAULT CURRENT_TIMESTAMP,
      PRIMARY KEY (`id`),
      UNIQUE KEY `patente` (`patente`),
      KEY `cliente_id` (`cliente_id`)
    ) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
    ";

    $pdo->exec($sqlCreate);
    echo "Tabla 'vehiculos' verificada/creada.\n";

    // 2. Migrar datos
    // Obtenemos los datos más recientes de cada patente de todas las tablas de ordenes.
    // Usamos UNION ALL y luego agrupamos por patente seleccionando el registro más reciente (por fecha o ID).

    echo "Analizando órdenes existentes para extraer vehículos...\n";

    // Consulta para obtener todos los vehículos únicos (normalizando por patente)
    // Priorizamos la fecha más reciente.
    $sqlMigration = "
        INSERT INTO vehiculos (cliente_id, patente, marca_modelo, ultimo_kms, fecha_actualizacion)
        SELECT 
            cliente_id, 
            UPPER(TRIM(patente)) as patente_limpia, 
            TRIM(vehiculo) as vehiculo_limpio, 
            kms, 
            MAX(fecha) as fecha_reciente
        FROM (
            SELECT cliente_id, patente, vehiculo, kms, fecha FROM ordenes_frenos WHERE patente IS NOT NULL AND patente != ''
            UNION ALL
            SELECT cliente_id, patente, vehiculo, kms, fecha FROM ordenes_motor WHERE patente IS NOT NULL AND patente != ''
            UNION ALL
            SELECT cliente_id, patente, vehiculo, kms, fecha FROM ordenes_suspension WHERE patente IS NOT NULL AND patente != ''
            UNION ALL
            SELECT cliente_id, patente, vehiculo, kms, fecha FROM ordenes_otros WHERE patente IS NOT NULL AND patente != ''
        ) as todas_ordenes
        GROUP BY patente_limpia
        ON DUPLICATE KEY UPDATE
            marca_modelo = VALUES(marca_modelo),
            ultimo_kms = VALUES(ultimo_kms),
            cliente_id = VALUES(cliente_id),
            fecha_actualizacion = VALUES(fecha_actualizacion);
    ";

    $stmt = $pdo->prepare($sqlMigration);
    $stmt->execute();

    echo "Migración completada. Filas afectadas: " . $stmt->rowCount() . "\n";

    // Verificación
    $count = $pdo->query("SELECT COUNT(*) FROM vehiculos")->fetchColumn();
    echo "Total de vehículos en la tabla: $count\n";

} catch (PDOException $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>