<?php
// D:\wamp64\www\shtaller-gk\setup_db.php

$host = 'localhost';
$db = 'shtaller';
$user = 'root';
$pass = '';
$charset = 'utf8mb4';

$dsn = "mysql:host=$host;dbname=$db;charset=$charset";
$options = [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES => false,
];

try {
    $pdo = new PDO($dsn, $user, $pass, $options);

    // 0. Crear tabla CONFIG (que faltaba y rompía db.php)
    $sqlConfig = "CREATE TABLE IF NOT EXISTS config (
        id INT PRIMARY KEY,
        nombre_taller VARCHAR(100) DEFAULT 'Taller Alberto',
        iva_responsable TINYINT DEFAULT 0,
        iva_porcentaje DECIMAL(5,2) DEFAULT 21.00,
        logo_path VARCHAR(255) DEFAULT ''
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
    $pdo->exec($sqlConfig);

    // Insertar config default si no existe
    $stmt = $pdo->query("SELECT COUNT(*) FROM config WHERE id = 1");
    if ($stmt->fetchColumn() == 0) {
        $pdo->exec("INSERT INTO config (id, nombre_taller) VALUES (1, 'Taller Alberto')");
        echo "Configuración base creada.<br>";
    }
    echo "Tabla 'config' verificada.<br>";

    // 1. Crear tabla unificada de Órdenes
    $sql = "CREATE TABLE IF NOT EXISTS ordenes (
        id INT AUTO_INCREMENT PRIMARY KEY,
        tipo VARCHAR(20) NOT NULL COMMENT 'frenos, motor, suspension, otros',
        orden_num VARCHAR(50) NOT NULL,
        cliente VARCHAR(100) DEFAULT NULL,
        fecha DATE,
        vehiculo VARCHAR(100),
        patente VARCHAR(20),
        kms VARCHAR(20),
        detalles_items JSON,
        total DECIMAL(10,2) DEFAULT 0.00,
        estado VARCHAR(20) DEFAULT 'pendiente',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

    $pdo->exec($sql);
    echo "Tabla 'ordenes' verificada/creada correctamente.<br>";

    // 2. Verificar/Crear tabla usuarios si no existe
    $sqlUsers = "CREATE TABLE IF NOT EXISTS usuarios (
        id INT AUTO_INCREMENT PRIMARY KEY,
        nombres VARCHAR(100),
        apellidos VARCHAR(100),
        usuario VARCHAR(50) UNIQUE,
        password VARCHAR(255),
        role VARCHAR(20) DEFAULT 'admin'
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";

    $pdo->exec($sqlUsers);
    echo "Tabla 'usuarios' verificada/creada correctamente.<br>";

    // 4. Crear tabla Clientes
    $sqlClientes = "CREATE TABLE IF NOT EXISTS clientes (
        id INT AUTO_INCREMENT PRIMARY KEY,
        nombres VARCHAR(100),
        apellidos VARCHAR(100),
        celular VARCHAR(50),
        domicilio VARCHAR(255),
        ciudad VARCHAR(100),
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
    $pdo->exec($sqlClientes);
    echo "Tabla 'clientes' verificada/creada correctamente.<br>";

    // 5. Crear tabla Turnos
    $sqlTurnos = "CREATE TABLE IF NOT EXISTS turnos (
        id INT AUTO_INCREMENT PRIMARY KEY,
        cliente_nombre VARCHAR(100),
        fecha DATE,
        hora TIME,
        descripcion TEXT,
        estado VARCHAR(20) DEFAULT 'Pendiente',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
    $pdo->exec($sqlTurnos);
    echo "Tabla 'turnos' verificada/creada correctamente.<br>";

    // 3. Crear usuario admin por defecto si no existe
    // user: admin, pass: admin123
    $stm = $pdo->prepare("SELECT COUNT(*) FROM usuarios WHERE usuario = 'admin'");
    $stm->execute();
    if ($stm->fetchColumn() == 0) {
        $pass = password_hash('admin123', PASSWORD_DEFAULT);
        $pdo->exec("INSERT INTO usuarios (nombres, apellidos, usuario, password) VALUES ('Administrador', 'Principal', 'admin', '$pass')");
        echo "Usuario admin defecto creado (admin/admin123).<br>";
    }

    // 6. Crear tabla Gastos
    $sqlGastos = "CREATE TABLE IF NOT EXISTS gastos (
        id INT AUTO_INCREMENT PRIMARY KEY,
        categoria VARCHAR(100) NOT NULL,
        monto DECIMAL(10,2) NOT NULL,
        descripcion TEXT,
        fecha DATE NOT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
    $pdo->exec($sqlGastos);
    echo "Tabla 'gastos' verificada/creada correctamente.<br>";

} catch (PDOException $e) {
    echo "Error en Base de Datos: " . $e->getMessage();
}
?>