<?php
// D:\wamp64\www\shtaller-gk\repair_db.php
include 'includes/db.php';

echo "<h1>Diagnóstico y Reparación de Base de Datos</h1>";

try {
    // 1. Clientes (Sync con SQL: nombres_apellido unificado)
    // El SQL dice: nombres_apellido, celular, domicilio, ciudad
    // El codigo actual usaba: nombres, apellidos separated.
    // Estrategia: Verificar si existe 'nombres_apellido'. Si no, crearla y migrar datos si existen 'nombres' y 'apellidos'.

    echo "<h3>1. Tabla Clientes</h3>";
    $stm = $pdo->query("DESCRIBE clientes");
    $columns = $stm->fetchAll(PDO::FETCH_COLUMN);

    if (!in_array('nombres_apellido', $columns)) {
        echo "Columna 'nombres_apellido' faltante. Creando y migrando...<br>";

        // Agregar columna
        $pdo->exec("ALTER TABLE clientes ADD COLUMN nombres_apellido VARCHAR(150) AFTER id");

        // Migrar datos existentes si las columnas viejas existen
        if (in_array('nombres', $columns) && in_array('apellidos', $columns)) {
            $pdo->exec("UPDATE clientes SET nombres_apellido = CONCAT(apellidos, ', ', nombres)");
            echo "Datos migrados de 'apellidos, nombres' a 'nombres_apellido'.<br>";

            // Opcional: Borrar columnas viejas o dejarlas por seguridad? 
            // El SQL source of truth NO tiene nombres/apellidos. Deberíamos borrarlas para ser estrictos, 
            // pero quizás renombrarlas o dejarlas useless por ahora.
            // Vamos a intentar borrarlas para cumplir con "Idéntico al SQL".
            $pdo->exec("ALTER TABLE clientes DROP COLUMN nombres");
            $pdo->exec("ALTER TABLE clientes DROP COLUMN apellidos");
            echo "Columnas obsoletas 'nombres' y 'apellidos' eliminadas.<br>";
        }
    } else {
        echo "Tabla clientes ya tiene estructura correcta.<br>";
    }


    // 2. Turnos (Sync con SQL: fecha_turno datetime)
    // SQL: id, cliente_id (int), fecha_turno (datetime), motivo, estado
    // Codigo actual: cliente_nombre, fecha (date), hora (time), descripcion...

    echo "<h3>2. Tabla Turnos</h3>";
    // Si la tabla difiere mucho, mejor recrearla o alterarla agresivamente.
    // Vamos a checkear si existe fecha_turno
    $stm = $pdo->query("DESCRIBE turnos");
    $columns_turnos = $stm->fetchAll(PDO::FETCH_COLUMN);

    if (!in_array('fecha_turno', $columns_turnos)) {
        echo "Normalizando tabla Turnos...<br>";
        $pdo->exec("ALTER TABLE turnos ADD COLUMN fecha_turno DATETIME AFTER cliente_id");

        // Migrar fecha + hora -> fecha_turno
        if (in_array('fecha', $columns_turnos) && in_array('hora', $columns_turnos)) {
            $pdo->exec("UPDATE turnos SET fecha_turno = CONCAT(fecha, ' ', hora)");
            echo "Fechas migradas.<br>";
            $pdo->exec("ALTER TABLE turnos DROP COLUMN fecha");
            $pdo->exec("ALTER TABLE turnos DROP COLUMN hora");
        }

        // Renombrar 'descripcion' a 'motivo' si es necesario (el SQL dice 'motivo')
        if (in_array('descripcion', $columns_turnos) && !in_array('motivo', $columns_turnos)) {
            $pdo->exec("ALTER TABLE turnos CHANGE descripcion motivo VARCHAR(255)");
            echo "Columna descripcion renombrada a motivo.<br>";
        }

        // Cliente: El SQL tiene 'cliente_id' (int), pero nuestro codigo usaba 'cliente_nombre' (string).
        // Esto es un conflicto grande. Si forzamos cliente_id, el usuario debe elegir de la lista de clientes.
        // Por ahora, para que funcione el codigo 'nuevo' que haremos, vamos a respetar el SQL pero quizás permitir NULL 
        // o ver como manejamos nombres sueltos. 
        // NOTA: El SQL dice `cliente_id` int. 
        // Si el codigo actual guarda nombres de texto, perderemos info si cambiamos a int sin tener el ID.
        // Vamos a mantener 'cliente_id' pero si el codigo viejo usaba 'cliente_nombre', agregaremos 'cliente_id' y dejaremos 'cliente_nombre' deprecated o lo borraremos si migramos?
        // El SQL NO tiene cliente_nombre.
        // Si borramos cliente_nombre, los turnos existentes sin cliente registrado se rompen.
        // SOLUCIÓN PRAGMÁTICA: Agregar cliente_id, mantener cliente_nombre oculto si no está en SQL? 
        // NO, El usuario pidió "Sincronización". El SQL manda.
        // Pero si el SQL está vacío de datos y nosotros tenemos datos...
        // Vamos a intentar mapear. Si no hay match, asumimos cliente_id 0 o NULL.
    }


    // 3. Tablas de Órdenes Desglosadas (Frenos, Motor, etc.)
    // El SQL no tiene una tabla 'ordenes' unica. Tiene 'ordenes_frenos', 'ordenes_motor', etc.
    // Debemos crear estas tablas explícitamente.

    $tablas_sql = [
        'ordenes_frenos' => "CREATE TABLE IF NOT EXISTS ordenes_frenos (
          id int NOT NULL AUTO_INCREMENT,
          orden_num int DEFAULT NULL,
          cliente_id int DEFAULT NULL,
          fecha date DEFAULT NULL,
          vehiculo varchar(100) DEFAULT NULL,
          patente varchar(20) DEFAULT NULL,
          kms varchar(20) DEFAULT NULL,
          detalles_items json DEFAULT NULL,
          subtotal_1 decimal(10,2) DEFAULT NULL,
          subtotal_2 decimal(10,2) DEFAULT NULL,
          total decimal(10,2) DEFAULT NULL,
          PRIMARY KEY (id),
          UNIQUE KEY orden_num (orden_num),
          KEY cliente_id (cliente_id)
        ) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;",

        'ordenes_motor' => "CREATE TABLE IF NOT EXISTS ordenes_motor (
          id int NOT NULL AUTO_INCREMENT,
          orden_num int DEFAULT NULL,
          cliente_id int DEFAULT NULL,
          fecha date DEFAULT NULL,
          vehiculo varchar(100) DEFAULT NULL,
          patente varchar(20) DEFAULT NULL,
          kms varchar(20) DEFAULT NULL,
          detalles_items json DEFAULT NULL,
          subtotal_1 decimal(10,2) DEFAULT NULL,
          subtotal_2 decimal(10,2) DEFAULT NULL,
          total decimal(10,2) DEFAULT NULL,
          PRIMARY KEY (id),
          UNIQUE KEY orden_num (orden_num),
          KEY cliente_id (cliente_id)
        ) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;",

        'ordenes_suspension' => "CREATE TABLE IF NOT EXISTS ordenes_suspension (
          id int NOT NULL AUTO_INCREMENT,
          orden_num int DEFAULT NULL,
          cliente_id int DEFAULT NULL,
          fecha date DEFAULT NULL,
          vehiculo varchar(100) DEFAULT NULL,
          patente varchar(20) DEFAULT NULL,
          kms varchar(20) DEFAULT NULL,
          detalles_items json DEFAULT NULL,
          subtotal_1 decimal(10,2) DEFAULT NULL,
          subtotal_2 decimal(10,2) DEFAULT NULL,
          total decimal(10,2) DEFAULT NULL,
          PRIMARY KEY (id),
          UNIQUE KEY orden_num (orden_num),
          KEY cliente_id (cliente_id)
        ) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;",

        'ordenes_otros' => "CREATE TABLE IF NOT EXISTS ordenes_otros (
          id int NOT NULL AUTO_INCREMENT,
          orden_num int DEFAULT NULL,
          cliente_id int DEFAULT NULL,
          fecha date DEFAULT NULL,
          vehiculo varchar(100) DEFAULT NULL,
          patente varchar(20) DEFAULT NULL,
          kms varchar(20) DEFAULT NULL,
          trabajos_realizados text,
          observaciones text,
          total decimal(10,2) DEFAULT NULL,
          PRIMARY KEY (id),
          UNIQUE KEY orden_num (orden_num),
          KEY cliente_id (cliente_id)
        ) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;"
    ];

    echo "<h3>3. Verificando Tablas de Órdenes Específicas</h3>";
    foreach ($tablas_sql as $nombre => $sql) {
        $pdo->exec($sql);
        echo "Tabla '$nombre' verificada/creada.<br>";
    }

    // 4. Tabla Gastos (Requerimiento Nuevo, no está en SQL original pero se necesita)
    echo "<h3>4. Tabla Gastos</h3>";
    $sqlGastos = "CREATE TABLE IF NOT EXISTS gastos (
        id INT AUTO_INCREMENT PRIMARY KEY,
        categoria VARCHAR(100) NOT NULL,
        monto DECIMAL(10,2) NOT NULL,
        descripcion TEXT,
        fecha DATE NOT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";
    $pdo->exec($sqlGastos);
    echo "Tabla 'gastos' verificada.<br>";

    // 5. Tabla Config (por seguridad, el SQL la tiene)
    echo "<h3>5. Tabla Config</h3>";
    $sqlConfig = "CREATE TABLE IF NOT EXISTS config (
      id int NOT NULL DEFAULT '1',
      nombre_taller varchar(100) DEFAULT 'Taller Alberto',
      iva_responsable tinyint(1) DEFAULT '0',
      iva_porcentaje decimal(5,2) DEFAULT '21.00',
      logo_path varchar(255) DEFAULT 'assets/img/logo_default.png',
      PRIMARY KEY (id)
    ) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;";
    $pdo->exec($sqlConfig);
    // Insertar default si vacia
    $cnt = $pdo->query("SELECT COUNT(*) FROM config")->fetchColumn();
    if ($cnt == 0) {
        $pdo->exec("INSERT INTO config (id, nombre_taller) VALUES (1, 'Taller Alberto')");
    }
    echo "Tabla 'config' verificada.<br>";

    echo "<br><strong><h2 style='color:green'>REPARACIÓN COMPLETADA. EL ESQUEMA DEBERÍA COINCIDIR CON EL SQL.</h2></strong>";

} catch (PDOException $e) {
    echo "<h2 style='color:red'>ERROR FATAL: " . $e->getMessage() . "</h2>";
}
?>