<?php
// procesar_vehiculo.php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}
include 'includes/db.php';

// Si es AJAX para select/información
if ($_SERVER['REQUEST_METHOD'] == 'GET' && isset($_GET['action']) && $_GET['action'] == 'get') {
    $id = $_GET['id'] ?? 0;
    if ($id) {
        $stmt = $pdo->prepare("SELECT * FROM vehiculos WHERE id = ?");
        $stmt->execute([$id]);
        echo json_encode($stmt->fetch(PDO::FETCH_ASSOC));
    }
    exit;
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $accion = $_POST['accion'] ?? '';
    $id = $_POST['id'] ?? null;

    // Datos comunes
    $patente = isset($_POST['patente']) ? strtoupper(trim($_POST['patente'])) : '';
    $modelo = trim($_POST['marca_modelo'] ?? '');
    $cliente_id = intval($_POST['cliente_id'] ?? 0);
    $anio = !empty($_POST['anio']) ? intval($_POST['anio']) : null;
    $kms = trim($_POST['ultimo_kms'] ?? '0');

    try {
        if ($accion == 'nuevo') {
            if (empty($patente) || empty($modelo)) {
                throw new Exception("Patente y Modelo son obligatorios.");
            }
            // Validar duplicado
            $stmtCheck = $pdo->prepare("SELECT id FROM vehiculos WHERE patente = ?");
            $stmtCheck->execute([$patente]);
            if ($stmtCheck->fetch()) {
                throw new Exception("La patente ya está registrada.");
            }

            $sql = "INSERT INTO vehiculos (cliente_id, patente, marca_modelo, anio, ultimo_kms, fecha_actualizacion) 
                    VALUES (:cliente_id, :patente, :modelo, :anio, :kms, NOW())";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([
                ':cliente_id' => $cliente_id,
                ':patente' => $patente,
                ':modelo' => $modelo,
                ':anio' => $anio,
                ':kms' => $kms
            ]);
            $msg = "Vehículo registrado correctamente.";

        } elseif ($accion == 'editar' && $id) {
            $sql = "UPDATE vehiculos SET 
                        cliente_id = :cliente_id,
                        patente = :patente,
                        marca_modelo = :modelo,
                        anio = :anio,
                        ultimo_kms = :kms,
                        fecha_actualizacion = NOW()
                    WHERE id = :id";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([
                ':cliente_id' => $cliente_id,
                ':patente' => $patente,
                ':modelo' => $modelo,
                ':anio' => $anio,
                ':kms' => $kms,
                ':id' => $id
            ]);
            $msg = "Vehículo actualizado correctamente.";

        } elseif ($accion == 'eliminar' && $id) {
            // Verificar dependencias? (Opcional, por ahora permitimos borrar el registro de vehiculo, 
            // aunque las ordenes quedarán con el texto histórico en 'patente' de la orden).
            $sql = "DELETE FROM vehiculos WHERE id = :id";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([':id' => $id]);
            $msg = "Vehículo eliminado correctamente.";
        }

        header("Location: vehiculos.php?status=success&msg=" . urlencode($msg));
        exit;

    } catch (Exception $e) {
        header("Location: vehiculos.php?status=error&msg=" . urlencode($e->getMessage()));
        exit;
    }
}
?>