<?php
// D:\wamp64\www\shtaller-gk\procesar_usuario.php
session_start();
include 'includes/db.php';

// Verificación de seguridad: solo administradores
if (!isset($_SESSION['user_id']) || $_SESSION['rol'] !== 'admin') {
    header("Location: index.php");
    exit;
}

// Capturar la acción y el ID (pueden venir por POST o GET)
$accion = $_POST['accion'] ?? $_GET['accion'] ?? '';
$id     = $_POST['id']     ?? $_GET['id']     ?? null;

try {
    if ($accion == 'nuevo') {
        // 1. CREAR NUEVO USUARIO
        $nombres   = trim($_POST['nombres']);
        $apellidos = trim($_POST['apellidos']);
        $usuario   = trim($_POST['usuario']);
        $rol       = $_POST['rol'];
        // Encriptar contraseña antes de guardar
        $pass_hash = password_hash($_POST['password'], PASSWORD_DEFAULT);

        $sql = "INSERT INTO usuarios (nombres, apellidos, usuario, password, rol, estado) 
                VALUES (?, ?, ?, ?, ?, 1)";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$nombres, $apellidos, $usuario, $pass_hash, $rol]);
        $msg = "Usuario creado con éxito.";

    } elseif ($accion == 'editar' && $id) {
        // 2. EDITAR PERFIL (No cambia la contraseña aquí)
        $nombres   = trim($_POST['nombres']);
        $apellidos = trim($_POST['apellidos']);
        $usuario   = trim($_POST['usuario']);
        $rol       = $_POST['rol'];
        $estado    = $_POST['estado'];

        $sql = "UPDATE usuarios SET nombres = ?, apellidos = ?, usuario = ?, rol = ?, estado = ? 
                WHERE id = ?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$nombres, $apellidos, $usuario, $rol, $estado, $id]);
        $msg = "Perfil actualizado correctamente.";

    } elseif ($accion == 'password' && $id) {
        // 3. CAMBIAR SOLO CONTRASEÑA
        $new_pass_hash = password_hash($_POST['password'], PASSWORD_DEFAULT);
        
        $sql = "UPDATE usuarios SET password = ? WHERE id = ?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$new_pass_hash, $id]);
        $msg = "Contraseña actualizada con éxito.";

    } elseif ($accion == 'status' && $id) {
        // 4. ALTERNAR ESTADO (Activo/Inactivo)
        $sql = "UPDATE usuarios SET estado = 1 - estado WHERE id = ?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$id]);
        $msg = "Estado del usuario modificado.";
    }

    // Redirección al finalizar
    header("Location: admin.php?status=success&msg=" . urlencode($msg));
    exit;

} catch (Exception $e) {
    // Manejo de errores (ej. usuario duplicado)
    header("Location: admin.php?status=error&msg=" . urlencode("Error: " . $e->getMessage()));
    exit;
}