<?php
session_start();
include 'includes/db.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['guardar_orden'])) {
    
    // 1. Recopilación de datos básicos
    $tipo_orden = $_POST['tipo_orden']; // frenos, motor, etc.
    $tabla = "ordenes_" . $tipo_orden;
    
    $orden_id = isset($_POST['orden_id']) ? intval($_POST['orden_id']) : 0;
    $cliente_id = $_POST['cliente_id'];
    $orden_num = $_POST['orden_num'];
    $fecha = $_POST['fecha'];
    $vehiculo = $_POST['vehiculo'];
    $patente = $_POST['patente'];
    $kms = $_POST['kms'];
    $total_final = $_POST['total_final'];

    // 2. Procesamiento de los ítems (JSON)
    $detalles_items = [];
    if (isset($_POST['item_nombre'])) {
        foreach ($_POST['item_nombre'] as $index => $nombre) {
            if (!empty($nombre)) {
                $detalles_items[] = [
                    'descripcion' => $nombre,
                    'realizado' => isset($_POST['item_check'][$index]) ? 'SI' : 'NO',
                    'precio' => isset($_POST['item_precio'][$index]) ? floatval($_POST['item_precio'][$index]) : 0
                ];
            }
        }
    }
    $json_items = json_encode($detalles_items, JSON_UNESCAPED_UNICODE);

    try {
        if ($orden_id > 0) {
            // --- MODO EDICIÓN: ACTUALIZAR ---
            // No incluimos orden_num en el SET para evitar el error de duplicado
            $sql = "UPDATE $tabla SET 
                    cliente_id = :cliente_id,
                    fecha = :fecha,
                    vehiculo = :vehiculo,
                    patente = :patente,
                    kms = :kms,
                    detalles_items = :detalles_items,
                    total = :total
                    WHERE id = :id";
            
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':id', $orden_id);
        } else {
            // --- MODO NUEVO: INSERTAR ---
            $sql = "INSERT INTO $tabla (orden_num, cliente_id, fecha, vehiculo, patente, kms, detalles_items, total) 
                    VALUES (:orden_num, :cliente_id, :fecha, :vehiculo, :patente, :kms, :detalles_items, :total)";
            
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':orden_num', $orden_num);
        }

        // Parámetros comunes
        $stmt->bindParam(':cliente_id', $cliente_id);
        $stmt->bindParam(':fecha', $fecha);
        $stmt->bindParam(':vehiculo', $vehiculo);
        $stmt->bindParam(':patente', $patente);
        $stmt->bindParam(':kms', $kms);
        $stmt->bindParam(':detalles_items', $json_items);
        $stmt->bindParam(':total', $total_final);

        if ($stmt->execute()) {
            header("Location: ordenes.php?status=success");
            exit;
        }

    } catch (PDOException $e) {
        die("Error crítico al procesar la orden: " . $e->getMessage());
    }
}