<?php
session_start();
include 'includes/db.php';

if (!isset($_SESSION['user_id']) || $_SESSION['rol'] !== 'admin') { exit; }

// PROCESAR CAMBIO DE LOGO
if (isset($_POST['update_logo'])) {
    $target_dir = "assets/img/";
    if (!file_exists($target_dir)) { mkdir($target_dir, 0777, true); }

    $ext = pathinfo($_FILES["logo"]["name"], PATHINFO_EXTENSION);
    $nombre_final = "logo_taller." . $ext;
    $ruta_completa = $target_dir . $nombre_final;

    if (move_uploaded_file($_FILES["logo"]["tmp_name"], $ruta_completa)) {
        $stmt = $pdo->prepare("UPDATE configuracion SET logo_path = ? WHERE id = 1");
        $stmt->execute([$ruta_completa]);
        header("Location: configuracion.php?status=ok");
    } else {
        header("Location: configuracion.php?status=error");
    }
}

// PROCESAR DATOS DE TEXTO
if (isset($_POST['update_info'])) {
    $sql = "UPDATE configuracion SET 
            nombre_taller = :nombre, 
            cuit = :cuit, 
            iva_condicion = :iva, 
            domicilio = :dom, 
            telefono = :tel, 
            email = :email 
            WHERE id = 1";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        ':nombre' => $_POST['nombre_taller'],
        ':cuit'   => $_POST['cuit'],
        ':iva'    => $_POST['iva_condicion'],
        ':dom'    => $_POST['domicilio'],
        ':tel'    => $_POST['telefono'],
        ':email'  => $_POST['email']
    ]);
    
    header("Location: configuracion.php?status=ok");
}