<?php
// D:\wamp64\www\shtaller-gk\procesar_cliente.php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

include 'includes/db.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // 1. Capturar y limpiar los datos del formulario
    $accion = $_POST['accion'] ?? '';
    $id = $_POST['id'] ?? null;
    $nombres_apellido = trim($_POST['nombres_apellido'] ?? '');
    $cuit_dni = trim($_POST['cuit_dni'] ?? '');
    $celular = trim($_POST['celular'] ?? ''); // Cambio de telefono a celular
    $domicilio = trim($_POST['domicilio'] ?? '');
    $ciudad = trim($_POST['ciudad'] ?? '');
    $vehiculo_modelo = trim($_POST['vehiculo_modelo'] ?? '');
    $patente = trim($_POST['patente'] ?? '');
    try {
        if ($accion == 'nuevo') {
            // Lógica para INSERTAR nuevo cliente con los 6 campos
            // CORRECCION: Eliminamos 'patente' de la tabla clientes, ya que no existe esa columna.
            $sql = "INSERT INTO clientes (nombres_apellido, cuit_dni, celular, domicilio, ciudad, vehiculo_modelo) 
                    VALUES (:nombre, :dni, :cel, :dom, :ciu, :vehiculo)";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([
                ':nombre' => $nombres_apellido,
                ':dni' => $cuit_dni,
                ':cel' => $celular,
                ':dom' => $domicilio,
                ':ciu' => $ciudad,
                ':vehiculo' => $vehiculo_modelo
            ]);
            $newId = $pdo->lastInsertId();
            $mensaje = "Cliente registrado con éxito.";

            // --- NUEVO: GUARDAR VEHÍCULO ASOCIADO ---
            $patente = isset($_POST['patente']) ? strtoupper(trim($_POST['patente'])) : '';
            if (!empty($patente)) {
                // Verificar si la patente ya existe logicamente
                $stmtV = $pdo->prepare("SELECT id FROM vehiculos WHERE patente = ?");
                $stmtV->execute([$patente]);
                $vExist = $stmtV->fetch();

                if ($vExist) {
                    // Si existe, actualizamos el dueño y datos
                    $updV = $pdo->prepare("UPDATE vehiculos SET cliente_id = ?, marca_modelo = ?, fecha_actualizacion = NOW() WHERE id = ?");
                    $updV->execute([$newId, $vehiculo_modelo, $vExist['id']]);
                } else {
                    // Insertamos nuevo
                    $insV = $pdo->prepare("INSERT INTO vehiculos (cliente_id, patente, marca_modelo, fecha_actualizacion, ultimo_kms) VALUES (?, ?, ?, NOW(), 0)");
                    $insV->execute([$newId, $patente, $vehiculo_modelo]);
                }
            }
            // ----------------------------------------

            // Si es AJAX, devolvemos JSON
            if (isset($_POST['ajax']) && $_POST['ajax'] == '1') {
                echo json_encode([
                    'status' => 'ok',
                    'message' => $mensaje,
                    'data' => [
                        'id' => $newId,
                        'nombres_apellido' => $nombres_apellido,
                        'patente' => $patente,
                        'vehiculo_modelo' => $vehiculo_modelo
                    ]
                ]);
                exit;
            }

        } elseif ($accion == 'editar' && $id) {
            // Lógica para ACTUALIZAR cliente existente
            // CORRECCION: Eliminamos 'patente' de update tabla clientes.
            $sql = "UPDATE clientes SET 
                        nombres_apellido = :nombre, 
                        cuit_dni = :dni, 
                        celular = :cel, 
                        domicilio = :dom, 
                        ciudad = :ciu, 
                        vehiculo_modelo = :vehiculo 
                    WHERE id = :id";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([
                ':nombre' => $nombres_apellido,
                ':dni' => $cuit_dni,
                ':cel' => $celular,
                ':dom' => $domicilio,
                ':ciu' => $ciudad,
                ':vehiculo' => $vehiculo_modelo,
                ':id' => $id
            ]);
            $mensaje = "Datos del cliente actualizados correctamente.";

            // --- NUEVO: Actualizar vehiculo ---
            $patente = isset($_POST['patente']) ? strtoupper(trim($_POST['patente'])) : '';
            if (!empty($patente)) {
                $stmtV = $pdo->prepare("SELECT id FROM vehiculos WHERE patente = ?");
                $stmtV->execute([$patente]);
                $vExist = $stmtV->fetch();

                if ($vExist) {
                    $updV = $pdo->prepare("UPDATE vehiculos SET cliente_id = ?, marca_modelo = ?, fecha_actualizacion = NOW() WHERE id = ?");
                    $updV->execute([$id, $vehiculo_modelo, $vExist['id']]);
                } else {
                    $insV = $pdo->prepare("INSERT INTO vehiculos (cliente_id, patente, marca_modelo, fecha_actualizacion, ultimo_kms) VALUES (?, ?, ?, NOW(), 0)");
                    $insV->execute([$id, $patente, $vehiculo_modelo]);
                }
            }
        }

        // Redireccionar con éxito (Si no es AJAX o es editar)
        header("Location: clientes.php?status=success&msg=" . urlencode($mensaje));
        exit;

    } catch (PDOException $e) {
        // En caso de error de base de datos, redirigir con el error
        header("Location: clientes.php?status=error&msg=" . urlencode("Error en la base de datos: " . $e->getMessage()));
        exit;
    }
} else {
    header("Location: clientes.php");
    exit;
}