<?php
include 'includes/header.php';

// Consulta Unificada
$sql = "
SELECT t.id, c.nombres_apellido as nombre_apellido, t.vehiculo, t.patente, t.total, t.fecha, 'Frenos' as categoria 
FROM ordenes_frenos t 
LEFT JOIN clientes c ON t.cliente_id = c.id
UNION ALL
SELECT t.id, c.nombres_apellido as nombre_apellido, t.vehiculo, t.patente, t.total, t.fecha, 'Motor' as categoria 
FROM ordenes_motor t 
LEFT JOIN clientes c ON t.cliente_id = c.id
UNION ALL
SELECT t.id, c.nombres_apellido as nombre_apellido, t.vehiculo, t.patente, t.total, t.fecha, 'Suspension' as categoria 
FROM ordenes_suspension t 
LEFT JOIN clientes c ON t.cliente_id = c.id
UNION ALL
SELECT t.id, c.nombres_apellido as nombre_apellido, t.vehiculo, t.patente, t.total, t.fecha, 'Otros' as categoria 
FROM ordenes_otros t 
LEFT JOIN clientes c ON t.cliente_id = c.id
ORDER BY fecha DESC";

$stmt = $pdo->query($sql);
$ordenes = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="p-4" style="position: relative; z-index: 10;">
    <h2 class="mb-4 text-purple">Listado de Órdenes</h2>

    <div class="card shadow-sm">
        <div class="card-body">
            <table id="tablaOrdenes" class="table table-striped table-hover mt-3" style="width:100%">
                <thead class="table-dark">
                    <tr>
                        <th>Fecha</th>
                        <th>Cliente</th>
                        <th>Vehículo</th>
                        <th>Patente</th>
                        <th>Categoría</th>
                        <th>Total</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($ordenes as $orden): ?>
                        <tr>
                            <td>
                                <?= date('d/m/Y', strtotime($orden['fecha'])) ?>
                            </td>
                            <td>
                                <?= htmlspecialchars($orden['nombre_apellido'] ?? 'Cliente Desconocido') ?>
                            </td>
                            <td>
                                <?= htmlspecialchars($orden['vehiculo']) ?>
                            </td>
                            <td>
                                <?= htmlspecialchars($orden['patente']) ?>
                            </td>
                            <td><span class="badge bg-secondary">
                                    <?= $orden['categoria'] ?>
                                </span></td>
                            <td>$
                                <?= number_format($orden['total'], 2, ',', '.') ?>
                            </td>
                            <td>
                                <div class="btn-group" role="group">
                                    <!-- Ver -->
                                    <a href="ver_orden.php?id=<?= $orden['id'] ?>&categoria=<?= strtolower($orden['categoria']) ?>"
                                        class="btn btn-info btn-sm text-white" target="_blank" title="Ver Hoja">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <!-- Imprimir -->
                                    <a href="ver_orden.php?id=<?= $orden['id'] ?>&categoria=<?= strtolower($orden['categoria']) ?>&print=true"
                                        class="btn btn-dark btn-sm" target="_blank" title="Imprimir">
                                        <i class="fas fa-print"></i>
                                    </a>
                                    <!-- Editar -->
                                    <a href="<?= strtolower($orden['categoria']) ?>.php?edit_id=<?= $orden['id'] ?>"
                                        class="btn btn-warning btn-sm" title="Editar">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <!-- Eliminar -->
                                    <a href="#"
                                        onclick="confirmarEliminar(<?= $orden['id'] ?>, '<?= strtolower($orden['categoria']) ?>')"
                                        class="btn btn-danger btn-sm" title="Eliminar">
                                        <i class="fas fa-trash-alt"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Scripts obligatorios para DataTables -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css">
<script src="https://code.jquery.com/jquery-3.7.0.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>

<script>
    $(document).ready(function () {
        $('#tablaOrdenes').DataTable({
            language: {
                url: '//cdn.datatables.net/plug-ins/1.13.4/i18n/es-ES.json'
            },
            order: [[0, 'desc']] // Ordenar por fecha descendente
        });
    });

    function confirmarEliminar(id, categoria) {
        if (confirm('¿Está seguro de que desea eliminar esta orden? Esta acción no se puede deshacer.')) {
            window.location.href = 'eliminar_orden.php?id=' + id + '&categoria=' + categoria;
        }
    }
</script>

<?php include 'includes/footer.php'; ?>