<?php
// D:\wamp64\www\shtaller-gk\login.php
session_start();
include 'includes/db.php';

$error = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Usamos trim() para eliminar espacios accidentales al inicio o final
    $user_input = trim($_POST['usuario']);
    $pass_input = $_POST['password'];

    try {
        // Buscamos el usuario
        $stmt = $pdo->prepare("SELECT * FROM usuarios WHERE usuario = ?");
        $stmt->execute([$user_input]);
        $user = $stmt->fetch();

        if ($user) {
            // PASO 1: ¿Coincide la contraseña?
            if (password_verify($pass_input, $user['password'])) {
                
                // PASO 2: ¿Está activo?
                if ($user['estado'] == 1) {
                    // ÉXITO TOTAL
                    $_SESSION['user_id'] = $user['id'];
                    $_SESSION['usuario'] = $user['usuario'];
                    $_SESSION['rol']     = $user['rol'];
                    $_SESSION['nombres'] = $user['nombres'] . ' ' . $user['apellidos'];

                    header("Location: index.php");
                    exit;
                } else {
                    $error = "DEPURACIÓN: Usuario encontrado y clave OK, pero el ESTADO es 0 (Inactivo).";
                }
            } else {
                $error = "DEPURACIÓN: Usuario encontrado, pero la CONTRASEÑA no coincide con el Hash.";
            }
        } else {
            $error = "DEPURACIÓN: El usuario '" . htmlspecialchars($user_input) . "' no existe en la tabla.";
        }
    } catch (PDOException $e) {
        $error = "ERROR DE BD: " . $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Login - Taller GK</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/main.css">
    <style>
        body { background-image: url('assets/img/bg-motor.jpg'); background-size: cover; height: 100vh; display: flex; align-items: center; justify-content: center; }
        .login-card { background: #5d50c6; color: white; border-radius: 20px; width: 400px; padding: 30px; box-shadow: 0 10px 30px rgba(0,0,0,0.5); }
    </style>
</head>
<body>
    <div class="login-card text-center">
        <h2 class="fw-bold mb-4">Taller GK</h2>
        
        <?php if ($error): ?>
            <div class="alert alert-warning small py-2 mb-3" style="color: #856404; background-color: #fff3cd;">
                <?= $error ?>
            </div>
        <?php endif; ?>

        <form method="POST">
            <div class="mb-3 text-start">
                <label class="form-label small fw-bold">USUARIO</label>
                <input type="text" name="usuario" class="form-control" required autofocus>
            </div>
            <div class="mb-4 text-start">
                <label class="form-label small fw-bold">CONTRASEÑA</label>
                <input type="password" name="password" class="form-control" required>
            </div>
            <button type="submit" class="btn btn-light w-100 fw-bold text-primary">INGRESAR</button>
        </form>
    </div>
</body>
</html>