<?php
// D:\wamp64\www\shtaller-gk\index.php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}
include 'includes/db.php';
include 'includes/header.php';

// CONSULTAS PARA ESTADÍSTICAS RÁPIDAS
try {
    $total_clientes = $pdo->query("SELECT COUNT(*) FROM clientes")->fetchColumn() ?: 0;
} catch (Exception $e) {
    $total_clientes = 0;
}

try {
    // Ajustado a la tabla de órdenes general que creamos hoy
    $total_ordenes = $pdo->query("SELECT COUNT(*) FROM ordenes_trabajo")->fetchColumn() ?: 0;
} catch (Exception $e) {
    $total_ordenes = 0;
}

try {
    // Total de turnos a futuro
    $total_turnos = $pdo->query("SELECT COUNT(*) FROM turnos WHERE fecha >= CURDATE()")->fetchColumn() ?: 0;
    // NUEVO: Turnos confirmados específicamente para HOY
    $turnos_confirmados_hoy = $pdo->query("SELECT COUNT(*) FROM turnos WHERE fecha = CURDATE() AND estado = 'confirmado'")->fetchColumn() ?: 0;
} catch (Exception $e) {
    $total_turnos = 0;
    $turnos_confirmados_hoy = 0;
}
?>

<style>
    :root {
        --primary-purple: #5d50c6;
        --light-purple: #a29bfe;
    }

    /* Tarjetas Modernizadas */
    .dashboard-card {
        background-color: white;
        color: #333;
        height: 160px;
        border-radius: 12px;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        text-decoration: none;
        transition: all 0.3s ease;
        border: 1px solid #eee;
        position: relative;
        overflow: hidden;
    }

    .dashboard-card:hover {
        transform: translateY(-8px);
        box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);
        border-color: var(--primary-purple);
        color: var(--primary-purple) !important;
    }

    .dashboard-card i {
        font-size: 2.5rem;
        margin-bottom: 12px;
        color: var(--primary-purple);
    }

    .dashboard-card span {
        font-size: 1rem;
        font-weight: 700;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    .card-badge {
        position: absolute;
        top: 15px;
        right: 15px;
        background: var(--primary-purple);
        color: white;
        font-size: 0.75rem;
        padding: 2px 8px;
        border-radius: 10px;
        font-weight: bold;
    }

    .welcome-banner {
        background: linear-gradient(135deg, var(--primary-purple), var(--light-purple));
        color: white;
        padding: 30px;
        border-radius: 15px;
        margin-bottom: 30px;
    }

    /* Estilo para el dato de confirmados */
    .text-confirmados {
        font-size: 0.75rem;
        font-weight: bold;
        color: #28a745; /* Verde para confirmados */
        margin-top: 5px;
    }
</style>

<div class="p-4">
    <div class="welcome-banner shadow-sm">
        <h2 class="fw-bold mb-1">¡Hola, <?= htmlspecialchars($_SESSION['user_name']) ?>!</h2>
        <p class="m-0 opacity-75">Bienvenido al panel de control de <?= htmlspecialchars($config['nombre_taller'] ?? 'Taller GK') ?>. 
           Aquí tienes un resumen de hoy.</p>
    </div>

    <div class="container-fluid">
        <div class="row g-4">
            <div class="col-md-3">
                <a href="orden_frenos.php" class="dashboard-card">
                    <i class="fas fa-circle-notch"></i>
                    <span>Frenos</span>
                </a>
            </div>
            <div class="col-md-3">
                <a href="orden_motor.php" class="dashboard-card">
                    <i class="fas fa-cogs"></i>
                    <span>Motor</span>
                </a>
            </div>
            <div class="col-md-3">
                <a href="orden_suspension.php" class="dashboard-card">
                    <i class="fas fa-tools"></i>
                    <span>Suspensión</span>
                </a>
            </div>
            <div class="col-md-3">
                <a href="orden_otros.php" class="dashboard-card">
                    <i class="fas fa-plus-circle"></i>
                    <span>Otros</span>
                </a>
            </div>

            <div class="col-md-3">
                <a href="ordenes.php" class="dashboard-card">
                    <span class="card-badge"><?= $total_ordenes ?></span>
                    <i class="fas fa-list-ol"></i>
                    <span>Ver Órdenes</span>
                </a>
            </div>
            <div class="col-md-3">
                <a href="clientes.php" class="dashboard-card">
                    <span class="card-badge"><?= $total_clientes ?></span>
                    <i class="fas fa-user-friends"></i>
                    <span>Clientes</span>
                </a>
            </div>
            <div class="col-md-3">
                <a href="turnos.php" class="dashboard-card">
                    <span class="card-badge"><?= $total_turnos ?></span>
                    <i class="fas fa-clock"></i>
                    <span>Turnos</span>
                    <div class="text-confirmados">
                        <i class="fas fa-check-circle small"></i> <?= $turnos_confirmados_hoy ?> CONFIRMADOS HOY
                    </div>
                </a>
            </div>
             <div class="col-md-3">
                <a href="hoja_de_servicio.php" class="dashboard-card">
                    <i class="fas fa-print"></i>
                    <span>Hoja de Servicio</span>
                </a>
            </div>
<!--            
            <div class="col-md-3">
                <a href="ayuda.php" class="dashboard-card">
                    <i class="fas fa-book"></i>
                    <span>Manual</span>
                </a>
            </div>
-->            
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>