<?php
// D:\wamp64\www\shtaller-gk\includes\template_orden.php

// Lógica para el Logotipo Personalizado
$ruta_logo = "uploads/logo_taller.png";
$clase_logo = (!file_exists($ruta_logo)) ? "no-logo" : "con-logo";
// Cálculo del Folio (Prefijo + MAX(id)+1)
$prefixMap = [
    'frenos' => 'F',
    'motor' => 'M',
    'suspension' => 'S',
    'otros' => 'O'
];
$prefix = $prefixMap[$tipo_db] ?? 'X';

// Aseguramos que la tabla existe para evitar errores si se ejecuta antes del setup
try {
    $tabla_orden = "ordenes_" . $tipo_db;
    $stmtMax = $pdo->query("SELECT MAX(id) FROM $tabla_orden");
    $maxId = $stmtMax->fetchColumn();
    $nextId = ($maxId) ? $maxId + 1 : 1;
    $folioFormatted = $prefix . "-" . str_pad($nextId, 3, "0", STR_PAD_LEFT);
} catch (Exception $e) {
    $folioFormatted = $prefix . "-???";
}
?>

<style>
    /* Estilos base del contenedor y la tarjeta */
    .orden-container {
        background-color: #f4f6f9;
        min-height: 100vh;
        padding: 10px;
    }

    .orden-card {
        background: white;
        border: 2px solid #000;
        padding: 25px;
        width: 100%;
        margin: 0;
        box-shadow: 0 4px 10px rgba(0, 0, 0, 0.05);
    }

    /* Header con Logotipo */
    .header-orden {
        display: flex;
        align-items: center;
        justify-content: space-between;
        margin-bottom: 20px;
        border-bottom: 1px double #000;
        padding-bottom: 10px;
    }

    .logo-area img {
        max-height: 70px;
        max-width: 200px;
        object-fit: contain;
    }

    .text-area {
        text-align: right;
    }

    .no-logo .header-orden {
        justify-content: center;
        text-align: center;
    }

    .no-logo .text-area {
        text-align: center;
    }

    .titulo-taller {
        font-size: 26px;
        font-weight: 800;
        margin: 0;
        color: #000;
    }

    .titulo-orden {
        font-size: 16px;
        font-weight: bold;
        text-transform: uppercase;
        color: #555;
    }

    .folio-badge {
        background-color: #5448B2;
        color: white;
        padding: 5px 10px;
        border-radius: 4px;
        font-size: 1.2em;
        font-weight: bold;
        margin-left: 10px;
        font-family: 'Courier New', monospace;
    }

    /* Estilos de Tablas y Entradas */
    .tabla-cabecera,
    .tabla-items {
        width: 100%;
        border-collapse: collapse;
        margin-bottom: 15px;
    }

    .tabla-cabecera th,
    .tabla-items th {
        border: 1px solid #000;
        padding: 6px;
        background: #f2f2f2;
        font-size: 11px;
        text-align: center;
    }

    .tabla-cabecera td,
    .tabla-items td {
        border: 1px solid #000;
        padding: 0;
    }

    .input-cabecera,
    .input-item,
    .input-precio {
        border: none;
        width: 100%;
        padding: 10px;
        outline: none;
        font-size: 14px;
        background: transparent;
        text-align: center;
    }

    .input-precio {
        text-align: right;
        font-family: 'Courier New', monospace;
        font-weight: 900;
        color: #1b5e20;
    }

    .chk-si {
        width: 18px;
        height: 18px;
        cursor: pointer;
        display: block;
        margin: 8px auto;
    }

    /* Footer y Totales */
    .footer-orden-nuevo {
        margin-top: 30px;
        display: flex;
        flex-direction: column;
        gap: 15px;
    }

    .footer-top-row {
        display: flex;
        gap: 30px;
        align-items: flex-start;
    }

    .obs-container {
        flex: 2;
        display: flex;
        flex-direction: column;
    }

    .obs-container label {
        font-weight: 800;
        font-size: 13px;
        margin-bottom: 8px;
        text-transform: uppercase;
    }

    .obs-container textarea {
        border: 1px solid #333;
        padding: 12px;
        height: 120px;
        resize: none;
        font-size: 14px;
    }

    .billing-container {
        flex: 1;
        min-width: 380px;
        display: flex;
        flex-direction: column;
        gap: 20px;
    }

    .total-box-final {
        border: 3px solid #000;
        padding: 20px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        background: #fff;
    }

    .total-box-final .label-total {
        font-size: 38px;
        font-weight: 400;
        color: #000;
    }

    .total-box-final .amount-total {
        font-size: 42px;
        font-weight: 400;
        font-family: Arial, sans-serif;
    }

    .btn-guardar-orden-final {
        background-color: #5d50c6;
        color: white;
        border: none;
        padding: 15px;
        font-size: 20px;
        border-radius: 12px;
        cursor: pointer;
        transition: background 0.3s;
        width: 100%;
    }

    @media print {

        .btn-guardar-orden-final,
        .btn-add-line,
        .btn-outline-info {
            display: none !important;
        }

        .total-box-final {
            border-width: 2px;
        }
    }
</style>

<div class="orden-container">
    <div class="container-fluid">
        <form action="guardar_orden_completa.php" method="POST" class="orden-card <?= $clase_logo ?>">
            <input type="hidden" name="tipo_orden" value="<?= $tipo_db ?>">

            <div class="header-orden">
                <?php if (file_exists($ruta_logo)): ?>
                    <div class="logo-area"><img src="<?= $ruta_logo ?>?v=<?= time() ?>"></div>
                <?php endif; ?>
                <div class="text-area">
                    <div class="titulo-taller">Taller Automotor</div>
                    <div class="d-flex align-items-center justify-content-end gap-2">
                        <div class="titulo-orden">
                            Orden: <?= $tipo_titulo ?>
                            <span class="folio-badge" title="Folio/Número de Orden"><?= $folioFormatted ?></span>
                        </div>
                        <button type="button" class="btn btn-primary btn-sm no-print" data-bs-toggle="modal"
                            data-bs-target="#modalBuscarVehiculo">
                            <i class="fas fa-search me-1"></i> Buscar Vehículo
                        </button>
                    </div>
                </div>
            </div>

            <table class="tabla-cabecera">
                <thead>
                    <tr>
                        <th>NOMBRES Y APELLIDO</th>
                        <th>FECHA</th>
                        <th>VEHICULO Marca/Modelo</th>
                        <th>PATENTE</th>
                        <th>KMS</th>
                    </tr>
                </thead>
                <tbody>
                    <tr id="fila-cabecera">
                        <td>
                            <select name="cliente_id" id="sel_cliente" class="input-cabecera" required>
                                <option value="">Seleccione...</option>
                                <?php
                                $stmt = $pdo->query("SELECT id, nombres_apellido FROM clientes ORDER BY nombres_apellido ASC");
                                while ($c = $stmt->fetch()): ?>
                                    <option value="<?= $c['id'] ?>"><?= htmlspecialchars($c['nombres_apellido']) ?></option>
                                <?php endwhile; ?>
                            </select>
                        </td>
                        <td><input type="date" name="fecha" class="input-cabecera" value="<?= date('Y-m-d') ?>"></td>
                        <td><input type="text" name="vehiculo" id="vehiculo" class="input-cabecera"
                                placeholder="Modelo..."></td>
                        <td>
                            <div class="input-group">
                                <input type="text" name="patente" id="patente" class="input-cabecera"
                                    placeholder="Ingrese patente..." autocomplete="off">
                                <button type="button" class="btn btn-sm btn-outline-info"
                                    onclick="verHistorialRapido()">Ver Historial</button>
                            </div>
                        </td>
                        <td><input type="text" name="kms" id="kms" class="input-cabecera" placeholder="00000"></td>
                    </tr>
                </tbody>
            </table>

            <div class="row g-0">
                <div class="col-md-6 border-end border-dark">
                    <table class="tabla-items">
                        <thead>
                            <tr>
                                <th>ÍTEMS</th>
                                <th style="width:40px">SI</th>
                                <th style="width:110px">$ PRECIO</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($items_fijos as $it): ?>
                                <tr>
                                    <td><input type="text" name="nombre_item[]" value="<?= $it ?>" class="input-item"
                                            readonly></td>
                                    <td><input type="checkbox" class="chk-si" onchange="actualizarTotal()"></td>
                                    <td><input type="number" name="precio_item[]" class="input-precio val-item" step="0.01"
                                            oninput="actualizarTotal()"></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
                <div class="col-md-6">
                    <table class="tabla-items">
                        <thead>
                            <tr>
                                <th>ADICIONALES</th>
                                <th style="width:40px">SI</th>
                                <th style="width:110px">$ PRECIO</th>
                            </tr>
                        </thead>
                        <tbody id="lista-adicionales">
                            <tr>
                                <td><input type="text" name="nombre_item[]" value="Mano de obra" class="input-item"
                                        readonly></td>
                                <td><input type="checkbox" class="chk-si" onchange="actualizarTotal()"></td>
                                <td><input type="number" name="precio_item[]" class="input-precio val-item" step="0.01"
                                        oninput="actualizarTotal()"></td>
                            </tr>
                        </tbody>
                    </table>
                    <div class="text-center pb-2"><button type="button" class="btn btn-sm btn-outline-dark"
                            onclick="agregarLinea()">+ Línea Extra</button></div>
                </div>
            </div>

            <div class="footer-orden-nuevo">
                <div class="footer-top-row">
                    <div class="obs-container">
                        <label>OBSERVACIONES DEL TRABAJO:</label>
                        <textarea name="notas" placeholder="Detalles técnicos..."></textarea>
                    </div>
                    <div class="billing-container">
                        <div class="total-box-final">
                            <span class="label-total">Total</span>
                            <span class="amount-total">$ <span id="txt-total">0,00</span></span>
                            <input type="hidden" name="total_final" id="inp-total" value="0">
                        </div>
                        <button type="submit" class="btn-guardar-orden-final">Guardar Orden de Trabajo</button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Modal Buscar Vehículo -->
<!-- Modal Buscar Vehículo movido a includes/modals_globales.php -->

<!-- Modal Nuevo Vehículo (Cuando no existe) -->
<!-- Modal Nuevo Vehículo movido a includes/modals_globales.php -->

<script>
    function agregarLinea() {
        const tr = document.createElement('tr');
        tr.innerHTML = `<td><input type="text" name="nombre_item[]" class="input-item" placeholder="..."></td><td class="text-center"><input type="checkbox" class="chk-si" onchange="actualizarTotal()" checked></td><td><input type="number" name="precio_item[]" class="input-precio val-item" step="0.01" oninput="actualizarTotal()" value="0"></td>`;
        document.getElementById('lista-adicionales').appendChild(tr);
    }
    function actualizarTotal() {
        let t = 0;
        // Solo buscamos en los campos de precio para mayor seguridad
        document.querySelectorAll('.val-item').forEach((p, i) => {
            // Buscamos el checkbox correspondiente a este campo de precio
            const c = document.querySelectorAll('.chk-si')[i];
            if (c && c.checked) t += parseFloat(p.value) || 0;
        });
        document.getElementById('txt-total').innerText = t.toLocaleString('es-AR', { minimumFractionDigits: 2 });
        document.getElementById('inp-total').value = t;
    }
</script>
<script src="assets/js/autocompletado_ordenes.js?v=<?= time() ?>"></script>
<?php include 'includes/footer.php'; ?>