<?php
// D:\wamp64\www\shtaller-gk\sidebar.php
// La variable $config ya viene cargada desde db.php
?>
<style>
    .sidebar {
        min-width: 280px;
        /* Un poco más ancho para el logo */
        max-width: 280px;
        background-color: var(--primary-purple);
        color: white;
        min-height: 100vh;
        display: flex;
        flex-direction: column;
        box-shadow: 4px 0 10px rgba(0, 0, 0, 0.1);
        z-index: 100;
    }

    /* Área del Logo al tope */
    .sidebar-logo-container {
        padding: 30px 20px;
        text-align: center;
        background: rgba(0, 0, 0, 0.15);
        /* Fondo sutilmente más oscuro */
        border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
    }

    .sidebar-logo-container img {
        max-width: 180px;
        max-height: 100px;
        object-fit: contain;
        filter: drop-shadow(0 4px 4px rgba(0, 0, 0, 0.2));
    }

    .sidebar-logo-placeholder {
        font-size: 3rem;
        color: rgba(255, 255, 255, 0.3);
    }

    /* Estilos de navegación */
    .sidebar .nav-link {
        color: rgba(255, 255, 255, 0.8);
        padding: 12px 25px;
        border-bottom: 1px solid rgba(255, 255, 255, 0.05);
        display: flex;
        align-items: center;
        transition: all 0.2s ease;
        text-decoration: none;
    }

    .sidebar .nav-link:hover {
        background-color: var(--light-purple);
        color: white;
        padding-left: 30px;
        /* Efecto de desplazamiento */
    }

    .sidebar .nav-link i {
        margin-right: 12px;
        width: 20px;
        text-align: center;
        font-size: 1.1rem;
    }

    .sidebar .nav-section-title {
        font-size: 0.7rem;
        text-transform: uppercase;
        padding: 25px 25px 8px;
        color: rgba(255, 255, 255, 0.4);
        font-weight: 800;
        letter-spacing: 1px;
    }

    .submenu {
        list-style: none;
        padding-left: 0;
        margin-bottom: 0;
    }

    .submenu .nav-link {
        padding-left: 50px;
        font-size: 0.85rem;
        opacity: 0.9;
    }

    .logout-section {
        margin-top: auto;
        padding: 20px 0;
        background: rgba(0, 0, 0, 0.1);
    }
</style>

<aside class="sidebar">
    <div class="sidebar-logo-container">
        <?php if (!empty($config['logo_path']) && file_exists($config['logo_path'])): ?>
            <img src="<?= $config['logo_path'] ?>" alt="Logo <?= htmlspecialchars($config['nombre_taller']) ?>">
        <?php else: ?>
            <div class="sidebar-logo-placeholder">
                <i class="fas fa-car-side"></i>
            </div>
            <small class="text-white-50 mt-2">Subir logo en Configuración</small>
        <?php endif; ?>
    </div>

    <nav class="flex-grow-1">
        <div class="nav-section-title">Principal</div>
        <a href="index.php" class="nav-link"><i class="fas fa-th-large"></i> Dashboard</a>

        <div class="nav-section-title">Operaciones</div>
        <ul class="submenu">
            <li>
                <a href="orden_frenos.php" class="nav-link">
                    <i class="fas fa-circle-notch"></i> Frenos
                </a>
            </li>
            <li>
                <a href="orden_suspension.php" class="nav-link">
                    <i class="fas fa-arrows-alt-v"></i> Suspensión
                </a>
            </li>
            <li>
                <a href="orden_motor.php" class="nav-link">
                    <i class="fas fa-cogs"></i> Motor
                </a>
            </li>
            <li>
                <a href="orden_otros.php" class="nav-link">
                    <i class="fas fa-tools"></i> Otros
                </a>
            </li>
        </ul>

        <div class="nav-section-title">Gestión</div>
        <a href="ordenes.php" class="nav-link"><i class="fas fa-clipboard-list"></i> Ver Órdenes</a>
        <a href="clientes.php" class="nav-link"><i class="fas fa-address-book"></i> Clientes</a>
        <a href="turnos.php" class="nav-link"><i class="fas fa-calendar-check"></i> Turnos</a>
        <a href="vehiculos.php" class="nav-link"><i class="fas fa-car"></i> Vehículos</a>

        <div class="nav-section-title">Finanzas</div>
        <a href="dashboard_financiero.php" class="nav-link"><i class="fas fa-dollar-sign"></i> Panel Financiero</a>

        <div class="nav-section-title">Herramientas</div>
        <a href="admin.php" class="nav-link"><i class="fas fa-user-shield"></i> Administración</a>

        <li class="nav-item" style="list-style: none;">
            <a href="ayuda.php" class="nav-link text-white opacity-75 hover-opacity-100">
                <i class="fas fa-question-circle me-2"></i>
                <span>Ayuda y Tutorial</span>
            </a>
        </li>
    </nav>

    <div class="logout-section">
        <a href="logout.php" class="nav-link text-white">
            <i class="fas fa-sign-out-alt me-2"></i> Cerrar Sesión
        </a>
    </div>
</aside>