<?php
// includes/modals_globales.php
// Centraliza los Modals para solucionar problemas de Z-Index y Backdrop

$currentPage = basename($_SERVER['PHP_SELF']);
$ordenPages = ['frenos.php', 'motor.php', 'orden_frenos.php', 'orden_motor.php', 'orden_suspension.php', 'orden_otros.php', 'ordenes.php', 'ver_orden.php', 'suspension.php', 'otros.php', 'checklist.php'];
?>

<?php if ($currentPage == 'clientes.php'): ?>
    <!-- === MODAL EDITAR VEHICULO (CLIENTES) === -->
    <div class="modal fade" id="modalEditarVehiculo" tabindex="-1" aria-hidden="true" style="z-index: 10050;">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content border-0 shadow-lg">
                <div class="modal-header bg-warning">
                    <h5 class="modal-title fw-bold text-dark"><i class="fas fa-edit me-2"></i> Editar Vehículo</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <form action="procesar_vehiculo.php" method="POST">
                    <input type="hidden" name="accion" value="editar">
                    <input type="hidden" name="id" id="edit_v_id">
                    <input type="hidden" name="redirect" value="clientes.php">

                    <div class="modal-body p-4">
                        <div class="mb-3">
                            <label class="form-label fw-bold">Patente</label>
                            <input type="text" name="patente" id="edit_v_patente" class="form-control text-uppercase"
                                required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-bold">Marca/Modelo</label>
                            <input type="text" name="marca_modelo" id="edit_v_modelo" class="form-control" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-bold">Año</label>
                            <input type="number" name="anio" id="edit_v_anio" class="form-control">
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-bold">Cliente ID</label>
                            <input type="text" name="cliente_id" id="edit_v_cliente" class="form-control" readonly>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-bold">Kms Actuales</label>
                            <input type="number" name="ultimo_kms" id="edit_v_kms" class="form-control">
                        </div>
                    </div>
                    <div class="modal-footer bg-light">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-warning fw-bold text-dark">Actualizar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php endif; ?>

<?php if ($currentPage == 'vehiculos.php'): ?>
    <!-- === MODALS VEHICULOS === -->
    <?php
    if (!isset($clientesList) && isset($pdo)) {
        $stmtC = $pdo->query("SELECT id, nombres_apellido FROM clientes ORDER BY nombres_apellido ASC");
        $clientesList = $stmtC->fetchAll();
    }
    ?>
    <!-- Modal Nuevo Vehículo -->
    <div class="modal fade" id="modalNuevoVehiculo" tabindex="-1" aria-hidden="true" style="z-index: 10050;">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content border-0 shadow-lg">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title fw-bold"><i class="fas fa-plus-circle me-2"></i> Nuevo Vehículo</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <form action="procesar_vehiculo.php" method="POST">
                    <input type="hidden" name="accion" value="nuevo">
                    <div class="modal-body p-4">
                        <div class="mb-3">
                            <label class="form-label fw-bold">Patente</label>
                            <input type="text" name="patente" class="form-control text-uppercase" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-bold">Marca/Modelo</label>
                            <input type="text" name="marca_modelo" class="form-control" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-bold">Año</label>
                            <input type="number" name="anio" class="form-control" placeholder="YYYY">
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-bold">Cliente</label>
                            <div class="input-group">
                                <select name="cliente_id" id="select_cliente_nuevo" class="form-select" required>
                                    <option value="">Seleccione Cliente...</option>
                                    <?php if (isset($clientesList))
                                        foreach ($clientesList as $cl): ?>
                                            <option value="<?= $cl['id'] ?>">
                                                <?= htmlspecialchars($cl['nombres_apellido']) ?>
                                            </option>
                                        <?php endforeach; ?>
                                </select>
                                <button type="button" class="btn btn-outline-secondary"
                                    onclick="abrirModalClienteExpress()">
                                    <i class="fas fa-user-plus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-bold">Kms Actuales</label>
                            <input type="number" name="ultimo_kms" class="form-control" value="0">
                        </div>
                    </div>
                    <div class="modal-footer bg-light">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-primary fw-bold">Guardar Vehículo</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal Editar Vehículo -->
    <div class="modal fade" id="modalEditarVehiculo" tabindex="-1" aria-hidden="true" style="z-index: 10050;">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content border-0 shadow-lg">
                <div class="modal-header bg-warning">
                    <h5 class="modal-title fw-bold text-dark"><i class="fas fa-edit me-2"></i> Editar Vehículo</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <form action="procesar_vehiculo.php" method="POST">
                    <input type="hidden" name="accion" value="editar">
                    <input type="hidden" name="id" id="edit_v_id">
                    <div class="modal-body p-4">
                        <div class="mb-3">
                            <label class="form-label fw-bold">Patente</label>
                            <input type="text" name="patente" id="edit_v_patente" class="form-control text-uppercase"
                                required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-bold">Marca/Modelo</label>
                            <input type="text" name="marca_modelo" id="edit_v_modelo" class="form-control" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-bold">Año</label>
                            <input type="number" name="anio" id="edit_v_anio" class="form-control">
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-bold">Cliente</label>
                            <select name="cliente_id" id="edit_v_cliente" class="form-select" required>
                                <option value="">Seleccione Cliente...</option>
                                <?php if (isset($clientesList))
                                    foreach ($clientesList as $cl): ?>
                                        <option value="<?= $cl['id'] ?>">
                                            <?= htmlspecialchars($cl['nombres_apellido']) ?>
                                        </option>
                                    <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-bold">Kms Actuales</label>
                            <input type="number" name="ultimo_kms" id="edit_v_kms" class="form-control">
                        </div>
                    </div>
                    <div class="modal-footer bg-light">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                        <button type="submit" class="btn btn-warning fw-bold text-dark">Actualizar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <form id="formEliminarVehiculo" action="procesar_vehiculo.php" method="POST">
        <input type="hidden" name="accion" value="eliminar">
        <input type="hidden" name="id" id="del_v_id">
    </form>
<?php endif; ?>

<?php if ($currentPage == 'turnos.php'): ?>
    <!-- === MODALS TURNOS === -->
    <div class="modal fade" id="modalTurno" tabindex="-1" aria-hidden="true" data-bs-backdrop="false"
        style="z-index: 10050;">
        <div class="modal-dialog modal-lg">
            <div class="modal-content shadow-lg">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title fw-bold">Programar Turno</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <form action="procesar_turno.php" method="POST">
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-12 mb-3">
                                <label class="form-label fw-bold">CLIENTE</label>
                                <select name="cliente_id" id="cliente_select" class="form-select" required>
                                    <option value="">Seleccione...</option>
                                    <?php
                                    if (isset($pdo)) {
                                        $clientes = $pdo->query("SELECT id, nombres_apellido FROM clientes ORDER BY nombres_apellido ASC")->fetchAll();
                                        foreach ($clientes as $c)
                                            echo "<option value='{$c['id']}'>{$c['nombres_apellido']}</option>";
                                    }
                                    ?>
                                </select>
                                <input type="hidden" name="nombres_apellido" id="hidden_nombre">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">VEHÍCULO</label>
                                <input type="text" name="vehiculo_modelo" id="t_vehiculo" class="form-control" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">PATENTE</label>
                                <input type="text" name="patente" id="t_patente" class="form-control" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">FECHA Y HORA</label>
                                <input type="datetime-local" name="fecha_turno" class="form-control" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">ESTADO INICIAL</label>
                                <select name="estado" class="form-select">
                                    <option value="Pendiente">Pendiente</option>
                                    <option value="Confirmado">Confirmado</option>
                                    <option value="Finalizado">Finalizado</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary w-100 fw-bold">GUARDAR TURNO</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="modalEditarTurno" tabindex="-1" aria-hidden="true" data-bs-backdrop="false"
        style="z-index: 10050;">
        <div class="modal-dialog modal-lg">
            <div class="modal-content shadow-lg">
                <div class="modal-header bg-warning text-dark">
                    <h5 class="modal-title fw-bold">Editar Turno</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <form action="actualizar_turno.php" method="POST">
                    <div class="modal-body">
                        <input type="hidden" name="id" id="edit_id">
                        <div class="row">
                            <div class="col-12 mb-3">
                                <label class="form-label fw-bold">CLIENTE</label>
                                <input type="text" id="edit_nombres_apellido" class="form-control bg-light" readonly>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">VEHÍCULO</label>
                                <input type="text" name="vehiculo_modelo" id="edit_vehiculo" class="form-control">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">PATENTE</label>
                                <input type="text" name="patente" id="edit_patente" class="form-control">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">FECHA Y HORA</label>
                                <input type="datetime-local" name="fecha_turno" id="edit_fecha" class="form-control">
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label fw-bold">ESTADO</label>
                                <select name="estado" id="edit_estado" class="form-select">
                                    <option value="Pendiente">Pendiente</option>
                                    <option value="Confirmado">Confirmado</option>
                                    <option value="En Taller">En Taller</option>
                                    <option value="Finalizado">Finalizado</option>
                                    <option value="Cancelado">Cancelado</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-warning w-100 fw-bold">ACTUALIZAR DATOS</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php endif; ?>

<?php if (in_array($currentPage, $ordenPages)): ?>
    <!-- === MODALS ORDENES === -->
    <div class="modal fade" id="modalBuscarVehiculo" tabindex="-1" aria-hidden="true" style="z-index: 10050;">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content border-0 shadow-lg">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title fw-bold"><i class="fas fa-car me-2"></i> Buscar Vehículo</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body p-4">
                    <div class="input-group mb-3">
                        <span class="input-group-text bg-light border-end-0"><i class="fas fa-search text-muted"></i></span>
                        <input type="text" id="inputBusquedaVehiculo"
                            class="form-control form-control-lg border-start-0 focus-ring"
                            placeholder="Ingrese Patente, Nombre o Modelo..." autocomplete="off">
                    </div>

                    <div class="table-responsive" style="max-height: 300px;">
                        <table class="table table-hover align-middle border" id="tablaResultadosVehiculo">
                            <thead class="table-light sticky-top">
                                <tr>
                                    <th>Patente</th>
                                    <th>Vehículo</th>
                                    <th>Cliente</th>
                                    <th class="text-end">Acción</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!-- Resultados aquí -->
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="modal-footer bg-light">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="modalNuevoVehiculo" tabindex="-1" aria-hidden="true" style="z-index: 10060;">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content border-0 shadow-lg">
                <div class="modal-header bg-success text-white">
                    <h5 class="modal-title fw-bold"><i class="fas fa-plus-circle me-2"></i> Registrar Nuevo Vehículo</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body p-4">
                    <form id="formNuevoVehiculo">
                        <div class="mb-3">
                            <label class="form-label fw-bold">Patente</label>
                            <input type="text" id="new_patente" name="patente" class="form-control text-uppercase" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-bold">Marca y Modelo</label>
                            <input type="text" id="new_modelo" name="marca_modelo" class="form-control"
                                placeholder="Ej: Fiat Cronos 1.3" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label fw-bold">Año (Opcional)</label>
                            <input type="number" id="new_anio" name="anio" class="form-control" placeholder="YYYY">
                        </div>

                        <!-- Cliente al que se asignará -->
                        <div class="mb-3">
                            <label class="form-label fw-bold">Asignar a Cliente</label>
                            <select id="new_cliente_id" name="cliente_id" class="form-select" required>
                                <option value="">Seleccione Cliente...</option>
                                <?php
                                if (isset($pdo)) {
                                    $stmtC = $pdo->query("SELECT id, nombres_apellido FROM clientes ORDER BY nombres_apellido ASC");
                                    while ($cl = $stmtC->fetch()): ?>
                                        <option value="<?= $cl['id'] ?>">
                                            <?= htmlspecialchars($cl['nombres_apellido']) ?>
                                        </option>
                                    <?php endwhile;
                                } ?>
                            </select>
                            <div class="form-text">Si el cliente no existe, regístrelo primero desde el menú principal.
                            </div>
                        </div>

                        <div class="text-end">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                            <button type="submit" class="btn btn-success fw-bold">Guardar y Seleccionar</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>

<!-- === MODALS GENERALES (CLIENTES Y USUARIOS) === -->
<div class="modal fade" id="modalNuevo" tabindex="-1" aria-hidden="true" style="z-index: 9999;">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content border-0 shadow-lg">
            <div class="modal-header text-white" style="background-color: #5d50c6;">
                <h5 class="modal-title fw-bold">REGISTRAR NUEVO CLIENTE</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form action="procesar_cliente.php" method="POST">
                <input type="hidden" name="accion" value="nuevo">
                <div class="modal-body p-4">
                    <div class="row g-3">
                        <div class="col-md-8">
                            <label class="form-label small fw-bold">NOMBRES Y APELLIDO</label>
                            <input type="text" name="nombres_apellido" class="form-control" required>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label small fw-bold">DNI / CUIT</label>
                            <input type="text" name="cuit_dni" class="form-control">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label small fw-bold">CELULAR</label>
                            <input type="text" name="celular" class="form-control">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label small fw-bold">VEHÍCULO (MARCA/MODELO)</label>
                            <input type="text" name="vehiculo_modelo" class="form-control">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label small fw-bold text-primary">PATENTE</label>
                            <input type="text" name="patente" class="form-control fw-bold border-primary"
                                style="text-transform: uppercase;">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label small fw-bold">DOMICILIO</label>
                            <input type="text" name="domicilio" class="form-control">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label small fw-bold">CIUDAD</label>
                            <input type="text" name="ciudad" class="form-control">
                        </div>
                    </div>
                </div>
                <div class="modal-footer bg-light">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary px-4 fw-bold">GUARDAR CLIENTE</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="modalEditar" tabindex="-1" aria-hidden="true" style="z-index: 9999;">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content border-0 shadow-lg">
            <div class="modal-header bg-warning">
                <h5 class="modal-title fw-bold text-dark">EDITAR DATOS DEL CLIENTE</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form action="procesar_cliente.php" method="POST">
                <input type="hidden" name="accion" value="editar">
                <input type="hidden" name="id" id="edit_id">
                <div class="modal-body p-4">
                    <div class="row g-3">
                        <div class="col-md-8">
                            <label class="form-label small fw-bold">NOMBRES Y APELLIDO</label>
                            <input type="text" name="nombres_apellido" id="edit_nombre" class="form-control" required>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label small fw-bold">DNI / CUIT</label>
                            <input type="text" name="cuit_dni" id="edit_dni" class="form-control">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label small fw-bold">CELULAR</label>
                            <input type="text" name="celular" id="edit_cel" class="form-control">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label small fw-bold">VEHÍCULO (MARCA/MODELO)</label>
                            <input type="text" name="vehiculo_modelo" id="edit_veh" class="form-control">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label small fw-bold text-primary">PATENTE</label>
                            <input type="text" name="patente" id="edit_patente"
                                class="form-control fw-bold border-primary" style="text-transform: uppercase;">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label small fw-bold">DOMICILIO</label>
                            <input type="text" name="domicilio" id="edit_dom" class="form-control">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label small fw-bold">CIUDAD</label>
                            <input type="text" name="ciudad" id="edit_ciu" class="form-control">
                        </div>
                    </div>
                </div>
                <div class="modal-footer bg-light">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-warning px-4 fw-bold text-dark">ACTUALIZAR DATOS</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="modalNuevoUsuario" tabindex="-1" aria-hidden="true" style="z-index: 10000;">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content border-0 shadow-lg">
            <div class="modal-header text-white" style="background-color: #5d50c6;">
                <h5 class="modal-title fw-bold">CREAR NUEVO USUARIO</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form action="procesar_usuario.php" method="POST">
                <input type="hidden" name="accion" value="nuevo">
                <div class="modal-body p-4">
                    <div class="row g-3">
                        <div class="col-6">
                            <label class="form-label small fw-bold">NOMBRES</label>
                            <input type="text" name="nombres" class="form-control" required>
                        </div>
                        <div class="col-6">
                            <label class="form-label small fw-bold">APELLIDOS</label>
                            <input type="text" name="apellidos" class="form-control" required>
                        </div>
                    </div>
                    <div class="mt-3">
                        <label class="form-label small fw-bold">USUARIO (LOGIN)</label>
                        <input type="text" name="usuario" class="form-control" required>
                    </div>
                    <div class="mt-3">
                        <label class="form-label small fw-bold">CONTRASEÑA</label>
                        <input type="password" name="password" class="form-control" required>
                    </div>
                    <div class="mt-3">
                        <label class="form-label small fw-bold">ROL</label>
                        <select name="rol" class="form-select">
                            <option value="mecanico">Mecánico</option>
                            <option value="admin">Administrador</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer bg-light">
                    <button type="submit" class="btn btn-primary w-100 fw-bold">GUARDAR USUARIO</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="modalEditarUsuario" tabindex="-1" aria-hidden="true" style="z-index: 10000;">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content border-0 shadow-lg">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title fw-bold">EDITAR PERFIL DE USUARIO</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form action="procesar_usuario.php" method="POST">
                <input type="hidden" name="accion" value="editar">
                <input type="hidden" name="id" id="edit_u_id">
                <div class="modal-body p-4">
                    <div class="row g-3">
                        <div class="col-6">
                            <label class="form-label small fw-bold">NOMBRES</label>
                            <input type="text" name="nombres" id="edit_u_nombres" class="form-control" required>
                        </div>
                        <div class="col-6">
                            <label class="form-label small fw-bold">APELLIDOS</label>
                            <input type="text" name="apellidos" id="edit_u_apellidos" class="form-control" required>
                        </div>
                    </div>
                    <div class="mt-3">
                        <label class="form-label small fw-bold">USUARIO (LOGIN)</label>
                        <input type="text" name="usuario" id="edit_u_login" class="form-control" required>
                    </div>
                    <div class="row mt-3">
                        <div class="col-6">
                            <label class="form-label small fw-bold">ROL</label>
                            <select name="rol" id="edit_u_rol" class="form-select">
                                <option value="mecanico">Mecánico</option>
                                <option value="admin">Administrador</option>
                            </select>
                        </div>
                        <div class="col-6">
                            <label class="form-label small fw-bold">ESTADO</label>
                            <select name="estado" id="edit_u_estado" class="form-select">
                                <option value="1">Activo</option>
                                <option value="0">Inactivo</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="modal-footer bg-light">
                    <button type="submit" class="btn btn-primary w-100 fw-bold">ACTUALIZAR DATOS</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="modalPassUsuario" tabindex="-1" aria-hidden="true" style="z-index: 10001;">
    <div class="modal-dialog modal-dialog-centered modal-sm">
        <div class="modal-content border-0 shadow-lg">
            <div class="modal-header bg-dark text-white">
                <h5 class="modal-title fw-bold">SEGURIDAD</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form action="procesar_usuario.php" method="POST">
                <input type="hidden" name="accion" value="password">
                <input type="hidden" name="id" id="pass_u_id">
                <div class="modal-body p-4 text-center">
                    <i class="fas fa-lock fa-3x mb-3 text-muted"></i>
                    <label class="form-label d-block small fw-bold text-uppercase">Nueva Contraseña</label>
                    <input type="password" name="password" class="form-control text-center" required minlength="4">
                </div>
                <div class="modal-footer bg-light">
                    <button type="submit" class="btn btn-dark w-100 fw-bold">CAMBIAR CLAVE</button>
                </div>
            </form>
        </div>
    </div>
</div>