<?php
// D:\wamp64\www\shtaller-gk\includes\header.php
// Sin espacios arriba de esta línea.
include_once 'db.php'; 

// Verificación de seguridad
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo isset($config['nombre_taller']) ? $config['nombre_taller'] : 'Taller'; ?> - Gestión</title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="assets/css/main.css">
</head>

<body>

    <div class="main-wrapper">

        <?php include 'sidebar.php'; ?>

        <div class="content-wrapper">

            <header class="main-header shadow-sm position-relative">

                <div class="header-left">
                </div>

                <div class="header-title-container">
                    <h3 class="workshop-name">
                        <?= htmlspecialchars($config['nombre_taller'] ?? 'Taller Automotor') ?>
                    </h3>
                </div>

                <div class="header-right ms-auto d-flex align-items-center">
                    <div class="search-box me-4">
                        <div class="input-group input-group-sm" style="width: 250px;">
                            <input type="text" class="form-control border-end-0" placeholder="Buscar...">
                            <span class="input-group-text bg-white border-start-0">
                                <i class="fas fa-search text-muted"></i>
                            </span>
                        </div>
                    </div>

                    <div class="user-info small d-none d-md-block">
                        <span class="text-muted">Hola,</span>
                        <span><?php echo $_SESSION['nombres'] ?? $_SESSION['usuario'] ?? 'Usuario'; ?></span>
                        <span class="badge bg-danger ms-1" style="font-size: 0.7rem;">
                            <?= strtoupper($_SESSION['rol']) ?>
                        </span>
                    </div>
                </div>
            </header>