<?php
/**
 * Archivo de conexión a la base de datos - Proyecto shtaller-gk
 */

// 1. Configuración de parámetros (En producción, estos cambiarán)
// Iniciar sesión de forma segura si no está iniciada
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

$host = 'localhost';
$db = 'shdrivecom_shalberto';
$user = 'shdrivecom_luisti';
$pass = 'Neuquen$2026';
$charset = 'utf8mb4';

$dsn = "mysql:host=$host;dbname=$db;charset=$charset";

$options = [
    // Indispensable: Lanza excepciones para atrapar errores de SQL
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    // Práctico: Devuelve los datos como array asociativo
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    // Seguridad: Desactiva emulación para evitar inyecciones SQL avanzadas
    PDO::ATTR_EMULATE_PREPARES => false,
];

try {
    $pdo = new PDO($dsn, $user, $pass, $options);
} catch (\PDOException $e) {
    // En producción, es mejor guardar esto en un log y no mostrarlo al usuario
    die("Error de conexión al taller: " . $e->getMessage());
}

/**
 * Carga global de la configuración del taller
 */
try {
    // Sincronizado con la tabla 'configuracion' de admin.php
    $stmt = $pdo->query("SELECT * FROM configuracion LIMIT 1");
    $config = $stmt->fetch();

    // Si la tabla existe pero está vacía, cargamos los valores por defecto
    if (!$config) {
        $config = [
            'nombre_taller' => 'Taller Alberto',
            'cuit' => '00-00000000-0',
            'iva_condicion' => 'Monotributista',
            'domicilio' => 'Dirección no configurada',
            'logo_path' => 'assets/img/logo_default.png'
        ];
    }
} catch (\PDOException $e) {
    // Si la tabla no existe aún (falla el SELECT), valores de emergencia
    $config = [
        'nombre_taller' => 'Taller Automotor',
        'cuit' => '',
        'iva_condicion' => '',
        'domicilio' => '',
        'logo_path' => ''
    ];
}