<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}
include 'includes/db.php';

$categoria = isset($_REQUEST['categoria']) ? $_REQUEST['categoria'] : 'frenos';
$formato = isset($_POST['formato']) ? $_POST['formato'] : 'a4';
$nombre_taller = isset($config['nombre_taller']) ? $config['nombre_taller'] : 'Taller Alberto';

// LISTA DE ÍTEMS
$items_db = [
    'frenos' => [
        "Pastillas de freno delanteras", "Pastillas de Freno Traseras", "Cintas de freno", 
        "Flexibles de freno", "Caño de frenos", "Cilindros de freno", 
        "Liquido de frenos Tipo", "Campanas", "Discos", "Rectificar campanas", 
        "Juego reparacion", "Encintar", "Reten/es", "Rectificar discos", 
        "Juego clavos de freno", "Juego zapatas nuevas", "Mano de obra"
    ],
    'motor' => [
        "Rectificar Tapa Cilindro", "Juego Juntas", "Juego Bulones", "Filtro Aceite", 
        "Aceite", "Kit Distribución", "Correa Poli V", "Tensor Correa", 
        "Tapones de Block", "Bomba Agua", "Refrigerante", "Rectificar Motor"
    ],
    'suspension' => [
        "Amortiguadores Traseros", "Parrillas Suspensión", "Bieletas", "Extremos", 
        "Rotulas", "Precap", "Fuelles Dirección", "Bujes Parrillas", "Cazoletas", "Rodillos Tensor"
    ],
    'otros' => []
];

$items_actuales = ($categoria == 'otros') ? [] : $items_db[$categoria];
$generar = isset($_POST['generar']) || (isset($_GET['print']) && $_GET['print'] == 'true');

include 'includes/header.php';
?>

<div class="main-layout d-flex no-print">
    <main class="content-area w-100 p-4">
        <h2 class="text-purple fw-bold mb-4"><i class="fas fa-print"></i> Hoja Manual para Taller</h2>
        <div class="card shadow-sm mb-4">
            <div class="card-body">
                <form method="POST">
                    <div class="row align-items-end">
                        <div class="col-md-3">
                            <label class="form-label fw-bold">Categoría</label>
                            <select name="categoria" class="form-select">
                                <option value="frenos" <?= $categoria == 'frenos' ? 'selected' : '' ?>>Frenos</option>
                                <option value="motor" <?= $categoria == 'motor' ? 'selected' : '' ?>>Motor</option>
                                <option value="suspension" <?= $categoria == 'suspension' ? 'selected' : '' ?>>Suspensión</option>
                                <option value="otros" <?= $categoria == 'otros' ? 'selected' : '' ?>>Otros</option>
                            </select>
                        </div>
                        <div class="col-md-9 text-end">
                            <button type="submit" name="generar" class="btn btn-primary shadow-sm">Generar Vista</button>
                            <a href="hoja_de_servicio.php" class="btn btn-outline-danger ms-2">Limpiar</a>

                            <?php if ($generar): ?>
                                <button type="button" onclick="window.print()" class="btn btn-dark ms-2"><i class="fas fa-print"></i></button>
                                <button type="button" onclick="exportarExcelFinal()" class="btn btn-success ms-2"><i class="fas fa-file-excel"></i> Excel</button>
                            <?php endif; ?>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </main>
</div>

<?php if ($generar): ?>
    <div class="preview-background">
        <div class="print-container shadow-lg">
            <div class="text-center mb-2">
                <h1 class="fw-bold m-0" style="font-size: 2.2rem; border-bottom: 2px solid #000; display: inline-block; padding: 0 40px;"><?= htmlspecialchars($nombre_taller) ?></h1>
            </div>

            <div class="d-flex justify-content-between mb-1 mt-1">
                <h6 class="m-0 fw-bold text-uppercase">ORDEN DE TRABAJO: <?= $categoria ?></h6>
                <h6 class="m-0 fw-bold">N°: __________</h6>
            </div>

            <table class="table-manual w-100 mb-2">
                <thead>
                    <tr><th width="35%">CLIENTE / CONTACTO</th><th width="15%">FECHA</th><th width="25%">VEHÍCULO</th><th width="15%">PATENTE</th><th width="10%">KMS</th></tr>
                </thead>
                <tbody><tr><td height="35"></td><td></td><td></td><td></td><td></td></tr></tbody>
            </table>

            <table class="table-manual w-100">
                <thead>
                    <tr><th>DESCRIPCIÓN DE TRABAJO / REPUESTO</th><th width="70">SI/NO</th><th width="120">IMPORTE ($)</th></tr>
                </thead>
                <tbody>
                    <?php foreach ($items_actuales as $item): ?>
                        <tr><td height="26" class="ps-2"><?= $item ?></td><td></td><td></td></tr>
                    <?php endforeach; ?>
                    <?php
                    $total_filas_hoja = 28; 
                    $extra = $total_filas_hoja - count($items_actuales);
                    for ($i = 0; $i < $extra; $i++): ?>
                        <tr><td height="26">&nbsp;</td><td></td><td></td></tr>
                    <?php endfor; ?>
                </tbody>
            </table>

            <div class="d-flex justify-content-end align-items-center mt-2">
                <h5 class="me-3 mb-0 fw-bold">TOTAL:</h5>
                <div style="border: 2px solid #000; width: 160px; height: 40px;"></div>
            </div>
        </div>
    </div>
<?php endif; ?>

<style>
    /* Fondo gris para resaltar la hoja blanca */
    .preview-background {
        background-color: #e9ecef;
        padding: 40px 0;
        min-height: 100vh;
    }

    /* Contenedor tipo Hoja A4 para la Web */
    .print-container {
        background-color: white;
        width: 210mm;
        min-height: 297mm;
        margin: 0 auto;
        padding: 15mm;
        border: 1px solid #d3d3d3;
        display: block !important;
    }

    .table-manual { border-collapse: collapse; border: 1.5px solid #000; }
    .table-manual th, .table-manual td { border: 1px solid #000; font-family: Arial, sans-serif; font-size: 11px; }
    .table-manual th { background: #f2f2f2 !important; text-align: center; padding: 3px; }

    /* Ajustes específicos para la IMPRESIÓN REAL */
@media print {
    @page { size: A4; margin: 8mm 10mm; }
    .no-print, header, footer, .main-layout { display: none !important; }
    .preview-background { background: none !important; padding: 0 !important; }
    
    .print-container {
        width: 100% !important;
        margin: 0 !important;
        /* Cambiamos 0 por 5mm para que el PDF no se pegue al borde */
        padding: 5mm !important; 
        border: none !important;
        box-shadow: none !important;
    }
}
</style>

<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
<script>
function exportarExcelFinal() {
    const datosParaExcel = <?= json_encode($items_actuales); ?>;
    let wb = XLSX.utils.book_new();
    let ws_data = [
        ["<?= strtoupper($nombre_taller) ?> - HOJA DE SERVICIO: <?= strtoupper($categoria) ?>"],
        [""],
        ["ITEM / TRABAJO", "REALIZADO", "PRECIO ($)"]
    ];

    if (datosParaExcel.length > 0) {
        datosParaExcel.forEach(it => { ws_data.push([it, "", ""]); });
    } else {
        for(let i=0; i<15; i++) { ws_data.push(["", "", ""]); }
    }

    let ws = XLSX.utils.aoa_to_sheet(ws_data);
    ws['!cols'] = [{ wch: 45 }, { wch: 15 }, { wch: 15 }];
    XLSX.utils.book_append_sheet(wb, ws, "HojaServicio");
    XLSX.writeFile(wb, "Hoja_Manual_<?= $categoria ?>.xlsx");
}
</script>
<?php include 'includes/footer.php'; ?>