<?php
// D:\wamp64\www\shtaller-gk\historial_vehiculo.php
session_start();
include 'includes/db.php';
include 'includes/header.php';

$patente = isset($_GET['patente']) ? trim($_GET['patente']) : '';

if (empty($patente)) {
    echo "<div class='container mt-4'><div class='alert alert-warning'>Ingrese una patente.</div></div>";
    exit;
}

// Consulta: Traemos órdenes de trabajo y el nombre del cliente que la pagó en ese momento
// Consulta: Traemos todas las reparaciones desde la vista global
$sql = "SELECT h.*, c.nombres_apellido 
        FROM view_historial_global h 
        LEFT JOIN clientes c ON h.cliente_id = c.id 
        WHERE h.patente = ? 
        ORDER BY h.fecha DESC";
$stmt = $pdo->prepare($sql);
$stmt->execute([$patente]);
$registros = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="container mt-4">
    <h2 class="mb-4">Historial de Patente: <span class="text-danger"><?php echo htmlspecialchars($patente); ?></span>
    </h2>

    <div class="table-responsive">
        <table class="table table-striped table-hover shadow-sm">
            <thead class="table-dark">
                <tr>
                    <th>Folio</th>
                    <th>Fecha</th>
                    <th>Dueño al momento</th>
                    <th>KMS</th>
                    <th>Sección</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($registros as $r):
                    // Calcular Folio
                    $t = $r['tipo']; // Frenos, Motor, Suspensión, Otros
                    $prefix = 'X';
                    if (strpos($t, 'Fren') !== false)
                        $prefix = 'F';
                    elseif (strpos($t, 'Mot') !== false)
                        $prefix = 'M';
                    elseif (strpos($t, 'Sus') !== false)
                        $prefix = 'S';
                    elseif (strpos($t, 'Otr') !== false)
                        $prefix = 'O';

                    $folio = $prefix . '-' . str_pad($r['orden_id'], 3, '0', STR_PAD_LEFT);
                    ?>
                    <tr>
                        <td class="fw-bold font-monospace text-danger"><?= $folio ?></td>
                        <td><?php echo date('d/m/Y', strtotime($r['fecha'])); ?></td>
                        <td><?php echo htmlspecialchars($r['nombres_apellido'] ?? 'S/D'); ?></td>
                        <td><?php echo number_format($r['kms'], 0, '', '.'); ?></td>
                        <td><span class="badge bg-secondary"><?php echo strtoupper($r['tipo']); ?></span></td>
                        <td>
                            <?php
                            $cat_slug = strtolower($r['tipo']);
                            $map = [
                                'frenos' => 'frenos',
                                'motor' => 'motor',
                                'suspensión' => 'suspension',
                                'otros' => 'otros'
                            ];
                            // Mejor manejo de tildes/utf8 para el slug si hiciera falta, 
                            // pero el map directo suele funcionar si el string es exacto.
                            // Fallback simple:
                            if (strpos($cat_slug, 'fren') !== false)
                                $slug = 'frenos';
                            elseif (strpos($cat_slug, 'mot') !== false)
                                $slug = 'motor';
                            elseif (strpos($cat_slug, 'sus') !== false)
                                $slug = 'suspension';
                            else
                                $slug = 'otros';
                            ?>
                            <a href="ver_orden.php?id=<?php echo $r['orden_id']; ?>&categoria=<?php echo $slug; ?>"
                                class="btn btn-sm btn-primary">Ver Detalles</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>