<?php
// D:\wamp64\www\shtaller-gk\guardar_orden_completa.php
session_start();
include 'includes/db.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // 1. Captura de datos generales (Cabecera)
    $cliente_id = $_POST['cliente_id'];
    $tipo_orden = $_POST['tipo_orden']; // frenos, motor, suspension, otros
    $fecha = $_POST['fecha'];
    $vehiculo = $_POST['vehiculo'];
    $patente = trim($_POST['patente']); // Importante trim
    $kms = $_POST['kms'];
    $total_final = $_POST['total_final'] ?? 0;
    $notas = $_POST['notas'] ?? '';

    // Validar tipo de orden
    $tipos_validos = ['frenos', 'motor', 'suspension', 'otros'];
    if (!in_array($tipo_orden, $tipos_validos)) {
        die("Error: Tipo de orden no válido.");
    }

    $tabla = "ordenes_" . $tipo_orden;

    // 2. Captura de arreglos de ítems (Detalle)
    $nombres_items = $_POST['nombre_item'] ?? [];
    $precios_items = $_POST['precio_item'] ?? [];

    // Construir estructura de ítems
    $detalles_array = [];
    $trabajos_texto = "";

    foreach ($nombres_items as $index => $nombre) {
        $precio = floatval($precios_items[$index] ?? 0);

        // Convertimos a detalle solo si tiene precio > 0  o si es un item fijo
        // Asumimos que si hay precio, se hizo.
        if ($precio > 0) {
            $detalles_array[] = [
                'descripcion' => $nombre,
                'precio' => $precio,
                'realizado' => 'SI'
            ];
            $trabajos_texto .= "- $nombre: $$precio\n";
        }
    }

    try {
        // Iniciamos transacción
        $pdo->beginTransaction();

        // 3. PERSISTENCIA EN TABLAS DE ORDENES (SEPARADAS)
        if ($tipo_orden === 'otros') {
            // Tabla 'ordenes_otros' usa 'trabajos_realizados' (TEXT) y 'observaciones' (TEXT)
            $sql = "INSERT INTO $tabla (cliente_id, fecha, vehiculo, patente, kms, trabajos_realizados, observaciones, total) 
                    VALUES (:cliente_id, :fecha, :vehiculo, :patente, :kms, :trabajos_realizados, :observaciones, :total)";

            $stmt = $pdo->prepare($sql);
            $stmt->execute([
                ':cliente_id' => $cliente_id,
                ':fecha' => $fecha,
                ':vehiculo' => $vehiculo,
                ':patente' => $patente,
                ':kms' => $kms,
                ':trabajos_realizados' => $trabajos_texto, // Texto plano
                ':observaciones' => $notas,
                ':total' => $total_final
            ]);
        } else {
            // Tablas 'ordenes_frenos', 'motor', 'suspension' usan 'detalles_items' (JSON)
            // No tienen columna 'observaciones' en schema original, pero podemos meter las notas en el JSON si queremos,
            // o simplemente ignorarlas si la tabla no las soporta.
            // Para asegurar compatibilidad, guardaremos solo lo que hay.

            $json_items = json_encode($detalles_array, JSON_UNESCAPED_UNICODE);

            // OJO: Estas tablas tienen columna 'subtotal_1' y 'subtotal_2' que podrian ser requeridas o no.
            // Asumimos NULL. 'orden_num' es UNIQUE pero nullable.

            $sql = "INSERT INTO $tabla (cliente_id, fecha, vehiculo, patente, kms, detalles_items, total) 
                    VALUES (:cliente_id, :fecha, :vehiculo, :patente, :kms, :detalles_items, :total)"; // Ignoramos notas por ahora si no hay campo

            $stmt = $pdo->prepare($sql);
            $stmt->execute([
                ':cliente_id' => $cliente_id,
                ':fecha' => $fecha,
                ':vehiculo' => $vehiculo,
                ':patente' => $patente,
                ':kms' => $kms,
                ':detalles_items' => $json_items,
                ':total' => $total_final
            ]);
        }

        $orden_id = $pdo->lastInsertId();

        // 4. PERSISTENCIA EN TABLA VEHICULOS (UPSERT)
        // Actualizamos o insertamos el vehículo para futuras búsquedas
        if (!empty($patente)) {
            $sqlVehiculo = "INSERT INTO vehiculos (cliente_id, patente, marca_modelo, ultimo_kms, fecha_actualizacion)
                            VALUES (:cliente_id, :patente, :modelo, :kms, NOW())
                            ON DUPLICATE KEY UPDATE
                            ultimo_kms = VALUES(ultimo_kms),
                            marca_modelo = VALUES(marca_modelo),
                            cliente_id = VALUES(cliente_id),
                            fecha_actualizacion = NOW()";

            $stmtVeh = $pdo->prepare($sqlVehiculo);
            $stmtVeh->execute([
                ':cliente_id' => $cliente_id,
                ':patente' => $patente,
                ':modelo' => $vehiculo,
                ':kms' => $kms
            ]);
        }

        // Si todo salió bien
        $pdo->commit();

        // Redirigir
        header("Location: ordenes.php?status=saved&id=" . $orden_id);
        exit;

    } catch (Exception $e) {
        $pdo->rollBack();
        die("Error crítico al guardar la orden: " . $e->getMessage());
    }
} else {
    header("Location: index.php");
    exit;
}
?>