<?php
// D:\wamp64\www\shtaller-gk\guardar_orden.php
session_start();
include 'includes/db.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // 1. Captura de datos de cabecera
    $cliente_id  = $_POST['cliente_id'];
    $tipo_orden  = $_POST['tipo_orden'] ?? 'frenos';
    $fecha       = date('Y-m-d');
    $total_monto = $_POST['total_monto'] ?? 0;
    $notas       = $_POST['notas'] ?? '';

    // 2. Captura de arreglos dinámicos
    $nombres_items = $_POST['item_nombre'] ?? [];
    $precios_items = $_POST['item_precio'] ?? [];

    try {
        // Iniciamos transacción para seguridad de datos
        $pdo->beginTransaction();

        // A. Insertar en la tabla principal (Cabecera)
        $sql_cabecera = "INSERT INTO ordenes (cliente_id, tipo_orden, fecha, total_monto, notas) 
                         VALUES (?, ?, ?, ?, ?)";
        $stmt = $pdo->prepare($sql_cabecera);
        $stmt->execute([$cliente_id, $tipo_orden, $fecha, $total_monto, $notas]);
        
        // Obtenemos el ID de la orden recién creada
        $orden_id = $pdo->lastInsertId();

        // B. Insertar los ítems (Solo los que tienen precio mayor a 0)
        $sql_items = "INSERT INTO ordenes_items (orden_id, descripcion, precio) VALUES (?, ?, ?)";
        $stmt_items = $pdo->prepare($sql_items);

        foreach ($nombres_items as $index => $nombre) {
            $precio = $precios_items[$index] ?? 0;

            // Solo guardamos si el precio es mayor a cero (ítems realizados)
            if ($precio > 0) {
                $stmt_items->execute([$orden_id, $nombre, $precio]);
            }
        }

        // Confirmamos la operación
        $pdo->commit();

        // Redirigir con mensaje de éxito
        header("Location: orden_frenos.php?status=ok&id=" . $orden_id);
        exit;

    } catch (Exception $e) {
        // Si algo falla, deshacemos los cambios
        $pdo->rollBack();
        die("Error crítico al guardar la orden: " . $e->getMessage());
    }
} else {
    header("Location: index.php");
    exit;
}