<?php
include 'includes/header.php';


// Inicializar variables
$msg = '';
$edit_mode = false;
$edit_data = [];

// Procesar Eliminar
if (isset($_GET['delete_id'])) {
    $id = $_GET['delete_id'];
    $stmt = $pdo->prepare("DELETE FROM gastos WHERE id = ?");
    if ($stmt->execute([$id])) {
        $msg = "<div class='alert alert-success'>Gasto eliminado correctamente</div>";
    } else {
        $msg = "<div class='alert alert-danger'>Error al eliminar gasto</div>";
    }
}

// Procesar Guardar / Actualizar
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['save_gasto'])) {
    $categoria = $_POST['categoria'];
    $numero_factura = $_POST['numero_factura'];
    $monto = $_POST['monto'];
    $descripcion = $_POST['descripcion'];
    $fecha = $_POST['fecha'];
    $gasto_id = $_POST['gasto_id'] ?? '';

    if (!empty($categoria) && !empty($monto) && !empty($fecha)) {
        if (!empty($gasto_id)) {
            // Actualizar
            $stmt = $pdo->prepare("UPDATE gastos SET categoria=?, numero_factura=?, monto=?, descripcion=?, fecha=? WHERE id=?");
            if ($stmt->execute([$categoria, $numero_factura, $monto, $descripcion, $fecha, $gasto_id])) {
                $msg = "<div class='alert alert-success'>Gasto actualizado correctamente</div>";
            } else {
                $msg = "<div class='alert alert-danger'>Error al actualizar gasto</div>";
            }
        } else {
            // Insertar Nuevo
            $stmt = $pdo->prepare("INSERT INTO gastos (categoria, numero_factura, monto, descripcion, fecha) VALUES (?, ?, ?, ?, ?)");
            if ($stmt->execute([$categoria, $numero_factura, $monto, $descripcion, $fecha])) {
                $msg = "<div class='alert alert-success'>Gasto registrado correctamente</div>";
            } else {
                $msg = "<div class='alert alert-danger'>Error al registrar gasto</div>";
            }
        }
    } else {
        $msg = "<div class='alert alert-warning'>Complete los campos obligatorios</div>";
    }
}

// Listar gastos
$stmt = $pdo->query("SELECT * FROM gastos ORDER BY fecha DESC, id DESC LIMIT 50");
$gastos = $stmt->fetchAll();
?>

<div class="p-4" style="position: relative; z-index: 10;">
        <h2 class="text-purple fw-bold mb-4"><i class="fas fa-wallet"></i> Gestión de Gastos</h2>
        <?= $msg ?>

        <div class="row">
            <!-- Formulario -->
            <div class="col-md-4">
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-light fw-bold" id="formTitle">Nuevo Gasto</div>
                    <div class="card-body">
                        <form method="POST" id="gastoForm">
                            <input type="hidden" name="save_gasto" value="1">
                            <input type="hidden" name="gasto_id" id="gasto_id">

                            <div class="mb-3">
                                <label class="form-label">Fecha</label>
                                <input type="date" name="fecha" id="fecha" class="form-control"
                                    value="<?= date('Y-m-d') ?>" required>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Categoría</label>
                                <select name="categoria" id="categoria" class="form-select" required>
                                    <option value="Servicios">Servicios (Luz, Gas, Internet)</option>
                                    <option value="Repuestos">Repuestos / Insumos</option>
                                    <option value="Personal">Personal / Sueldos</option>
                                    <option value="Alquiler">Alquiler</option>
                                    <option value="Impuestos">Impuestos</option>
                                    <option value="Otros">Otros</option>
                                </select>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Factura Número:</label>
                                <input type="text" name="numero_factura" id="numero_factura" class="form-control"
                                    placeholder="Ej: 0001-00001234">
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Descripción</label>
                                <textarea name="descripcion" id="descripcion" class="form-control" rows="2"></textarea>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Monto ($)</label>
                                <input type="number" step="0.01" name="monto" id="monto" class="form-control" required>
                            </div>

                            <button type="submit" class="btn btn-primary w-100" id="btnSubmit">Registrar Gasto</button>

                            <div id="cancelContainer" class="mt-2 text-center" style="display:none;">
                                <button type="button" class="btn btn-link text-danger text-decoration-none"
                                    onclick="resetForm()">2.- Cancelar</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Tabla -->
            <div class="col-md-8">
                <div class="card shadow-sm">
                    <div class="card-header bg-light fw-bold">Últimos Gastos</div>
                    <div class="card-body p-0">
                        <table class="table table-striped table-hover mb-0 datatable-auto">
                            <thead>
                                <tr>
                                    <th>Fecha</th>
                                    <th>Categoría</th>
                                    <th>N. Factura</th> <!-- Title requested -->
                                    <th>Descripción</th>
                                    <th class="text-end">Monto</th>
                                    <th class="text-end">Acciones</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($gastos as $g): ?>
                                    <tr>
                                        <td><?= date('d/m/Y', strtotime($g['fecha'])) ?></td>
                                        <td><span class="badge bg-secondary"><?= htmlspecialchars($g['categoria'] ?? '') ?></span>
                                        </td>
                                        <td><?= htmlspecialchars($g['numero_factura'] ?? '') ?>
                                        </td>
                                        <td><?= htmlspecialchars($g['descripcion'] ?? '') ?></td>
                                        <td class="text-end fw-bold">$ <?= number_format($g['monto'], 2, ',', '.') ?></td>
                                        <td class="text-end">
                                            <button class="btn btn-sm btn-outline-primary me-1"
                                                onclick='editGasto(<?= json_encode($g) ?>)'>
                                                <i class="fas fa-edit"></i>
                                            </button>
                                            <a href="gastos.php?delete_id=<?= $g['id'] ?>"
                                                class="btn btn-sm btn-outline-danger"
                                                onclick="return confirm('¿Estás seguro de eliminar este gasto?');">
                                                <i class="fas fa-trash"></i>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
</div>

<script>
    function editGasto(data) {
        // Llenar formulario
        document.getElementById('gasto_id').value = data.id;
        document.getElementById('fecha').value = data.fecha.split(' ')[0]; // Solo fecha YYYY-MM-DD
        document.getElementById('categoria').value = data.categoria;
        document.getElementById('numero_factura').value = data.numero_factura;
        document.getElementById('descripcion').value = data.descripcion;
        document.getElementById('monto').value = data.monto;

        // Cambiar estado visual
        document.getElementById('formTitle').innerText = 'Editar Gasto';
        document.getElementById('btnSubmit').innerText = 'Actualizar Gasto';
        document.getElementById('btnSubmit').classList.replace('btn-primary', 'btn-warning');
        document.getElementById('cancelContainer').style.display = 'block';

        // Scroll al formulario
        document.getElementById('gastoForm').scrollIntoView({ behavior: 'smooth' });
    }

    function resetForm() {
        document.getElementById('gastoForm').reset();
        document.getElementById('gasto_id').value = '';

        // Restaurar estado visual
        document.getElementById('formTitle').innerText = 'Nuevo Gasto';
        document.getElementById('btnSubmit').innerText = 'Registrar Gasto';
        document.getElementById('btnSubmit').classList.replace('btn-warning', 'btn-primary');
        document.getElementById('cancelContainer').style.display = 'none';

        // Restaurar fecha hoy
        document.getElementById('fecha').value = new Date().toISOString().split('T')[0];
    }
</script>

<?php include 'includes/footer.php'; ?>