<?php
session_start();
require_once 'includes/db.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

if (!isset($_GET['id']) || !isset($_GET['categoria'])) {
    die("Parámetros insuficientes.");
}

$id = intval($_GET['id']);
$categoria = $_GET['categoria'];

$tabla = '';
switch (strtolower($categoria)) {
    case 'frenos':
        $tabla = 'ordenes_frenos';
        break;
    case 'motor':
        $tabla = 'ordenes_motor';
        break;
    case 'suspension':
        $tabla = 'ordenes_suspension';
        break;
    case 'otros':
        $tabla = 'ordenes_otros';
        break;
    default:
        die("Categoría inválida.");
}

try {
    $stmt = $pdo->prepare("DELETE FROM $tabla WHERE id = ?");
    $stmt->execute([$id]);

    // Redireccionar con mensaje
    header("Location: ordenes.php?status=deleted");
    exit;
} catch (PDOException $e) {
    die("Error al eliminar: " . $e->getMessage());
}
?>