<?php
// debug_auth.php - Sube este archivo a tu servidor Ubuntu y ejecútalo (midominio.com/debug_auth.php)
// BORRALO INMEDIATAMENTE DESPUÉS DE USARLO

ini_set('display_errors', 1);
error_reporting(E_ALL);

include 'includes/db.php';

echo "<h2>Debug de Autenticación</h2>";
echo "<p>PHP Version: " . phpversion() . "</p>";

// 1. Probar conexión
try {
    $stmt = $pdo->query("SELECT 1");
    echo "<p style='color:green'>✅ Conexión a Base de Datos OK.</p>";
} catch (Exception $e) {
    die("<p style='color:red'>❌ Error de Conexión: " . $e->getMessage() . "</p>");
}

// 2. Verificar usuario 'admin'
$usuario = 'admin'; // El usuario que intentas usar
$pass_raw = 'admin123'; // La contraseña que intentas usar

echo "<h3>Verificando usuario: $usuario</h3>";

$stmt = $pdo->prepare("SELECT * FROM usuarios WHERE usuario = ?");
$stmt->execute([$usuario]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if ($user) {
    echo "<p style='color:green'>✅ Usuario encontrado en BD (ID: " . $user['id'] . ")</p>";
    echo "<p>Hash almacenado: " . $user['password'] . "</p>";

    // 3. Verificar hash
    if (password_verify($pass_raw, $user['password'])) {
        echo "<p style='color:green'>✅ La contraseña '$pass_raw' coincide con el hash.</p>";
    } else {
        echo "<p style='color:red'>❌ La contraseña '$pass_raw' NO coincide con el hash.</p>";

        // Generar nuevo hash para probar
        $new_hash = password_hash($pass_raw, PASSWORD_DEFAULT);
        echo "<p>Nuevo hash generado para '$pass_raw': <br><code>$new_hash</code></p>";
        echo "<p>Si copias este hash y lo actualizas en la BD, debería funcionar.</p>";
    }
} else {
    echo "<p style='color:red'>❌ El usuario '$usuario' NO existe en la tabla 'usuarios'.</p>";

    // Verificando si la tabla tiene datos
    $count = $pdo->query("SELECT COUNT(*) FROM usuarios")->fetchColumn();
    echo "<p>Total de usuarios en la tabla: $count</p>";

    // Verificando si existe 'Admin' o algo parecido (Case Sensitivity)
    $stmt = $pdo->query("SELECT usuario FROM usuarios");
    $all_users = $stmt->fetchAll(PDO::FETCH_COLUMN);
    echo "<p>Usuarios existentes: " . implode(", ", $all_users) . "</p>";
}
?>