<?php
session_start();
if (!isset($_SESSION['user_id']) || $_SESSION['rol'] !== 'admin') {
    header("Location: index.php");
    exit;
}
include 'includes/db.php';
include 'includes/header.php';

// Obtenemos los datos actuales de tu tabla
$stmt = $pdo->query("SELECT * FROM configuracion WHERE id = 1");
$config = $stmt->fetch();
?>

<div class="p-4" style="position: relative; z-index: 1;">
    <h3 class="fw-bold text-dark mb-4"><i class="fas fa-tools me-2" style="color: #5d50c6;"></i> Ajustes del Taller</h3>

    <div class="row g-4">
        <div class="col-md-5">
            <div class="card shadow-sm border-0 rounded-4">
                <div class="card-body text-center p-4">
                    <h5 class="fw-bold mb-3">Identidad Visual</h5>
                    <div class="p-3 border rounded-3 mb-3 bg-light d-flex align-items-center justify-content-center"
                        style="height: 200px;">
                        <img src="<?= $config['logo_path'] ?: 'assets/img/logo_default.png' ?>" class="img-fluid"
                            style="max-height: 100%;">
                    </div>
                    <form action="procesar_configuracion.php" method="POST" enctype="multipart/form-data">
                        <input type="file" name="logo" class="form-control mb-3" accept="image/*" required>
                        <button type="submit" name="update_logo" class="btn btn-primary w-100 fw-bold">ACTUALIZAR
                            LOGO</button>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-md-7">
            <div class="card shadow-sm border-0 rounded-4">
                <div class="card-body p-4">
                    <h5 class="fw-bold mb-4">Información del Negocio</h5>
                    <form action="procesar_configuracion.php" method="POST">
                        <div class="row g-3">
                            <div class="col-md-12">
                                <label class="form-label small fw-bold">NOMBRE COMERCIAL</label>
                                <input type="text" name="nombre_taller" class="form-control"
                                    value="<?= htmlspecialchars($config['nombre_taller'] ?? '') ?>" required>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label small fw-bold">CUIT</label>
                                <input type="text" name="cuit" class="form-control"
                                    value="<?= htmlspecialchars($config['cuit'] ?? '') ?>">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label small fw-bold">CONDICIÓN IVA</label>
                                <input type="text" name="iva_condicion" class="form-control"
                                    value="<?= htmlspecialchars($config['iva_condicion'] ?? '') ?>"
                                    placeholder="Ej: Responsable Inscripto">
                            </div>
                            <div class="col-md-12">
                                <label class="form-label small fw-bold">DOMICILIO</label>
                                <input type="text" name="domicilio" class="form-control"
                                    value="<?= htmlspecialchars($config['domicilio'] ?? '') ?>">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label small fw-bold">TELÉFONO</label>
                                <input type="text" name="telefono" class="form-control"
                                    value="<?= htmlspecialchars($config['telefono'] ?? '') ?>">
                            </div>
                            <div class="col-md-6">
                                <label class="form-label small fw-bold">EMAIL</label>
                                <input type="email" name="email" class="form-control"
                                    value="<?= htmlspecialchars($config['email'] ?? '') ?>">
                            </div>
                        </div>
                        <hr class="my-4">
                        <button type="submit" name="update_info" class="btn btn-dark w-100 fw-bold py-2">GUARDAR TODOS
                            LOS CAMBIOS</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>