<?php
// clientes.php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}
include 'includes/db.php';
include 'includes/header.php';

// 1. Obtener Clientes con conteo de vehículos
$sqlClientes = "
    SELECT c.*, COUNT(v.id) as cant_vehiculos 
    FROM clientes c 
    LEFT JOIN vehiculos v ON c.id = v.cliente_id 
    GROUP BY c.id 
    ORDER BY c.nombres_apellido ASC
";
$clientes = $pdo->query($sqlClientes)->fetchAll(PDO::FETCH_ASSOC);

// 2. Obtener Todos los Vehículos para asociarlos en el frontend
$sqlVehiculos = "SELECT * FROM vehiculos ORDER BY fecha_actualizacion DESC";
$allVehiculos = $pdo->query($sqlVehiculos)->fetchAll(PDO::FETCH_ASSOC);

// Agrupar vehículos por cliente_id para fácil acceso
$vehiculosPorCliente = [];
foreach ($allVehiculos as $v) {
    $v['link_historial'] = "historial_vehiculo.php?patente=" . urlencode($v['patente']);
    $vehiculosPorCliente[$v['cliente_id']][] = $v;
}
?>

<style>
    /* Estilos personalizados para la tabla y colapso */
    .btn-toggle-row {
        transition: transform 0.2s;
        border-radius: 50%;
        width: 30px;
        height: 30px;
        padding: 0;
        display: inline-flex;
        align-items: center;
        justify-content: center;
    }

    .btn-toggle-row[aria-expanded="true"] {
        background-color: #dc3545 !important;
        border-color: #dc3545 !important;
        transform: rotate(45deg);
        /* Efecto visual opcional */
    }

    .badge-vehiculos {
        background-color: #5d50c6;
        color: white;
        border-radius: 50%;
        padding: 0.35em 0.6em;
        font-size: 0.75em;
        margin-left: 8px;
        vertical-align: middle;
    }

    .nested-table-container {
        background-color: #f8f9fa;
        border-left: 4px solid #5d50c6;
    }

    .table-vehicles th {
        background-color: #e9ecef;
        font-size: 0.85rem;
    }
</style>

<div class="p-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="fw-bold text-dark m-0">
            <i class="fas fa-users me-2" style="color: #5d50c6;"></i> Gestión de Clientes
        </h3>
        <button class="btn btn-primary px-4 fw-bold shadow-sm" data-bs-toggle="modal" data-bs-target="#modalNuevo">
            <i class="fas fa-user-plus me-1"></i> NUEVO CLIENTE
        </button>
    </div>

    <?php if (isset($_GET['msg'])): ?>
        <div class="alert alert-<?= $_GET['status'] == 'success' ? 'success' : 'danger' ?> alert-dismissible fade show">
            <?= htmlspecialchars($_GET['msg']) ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <div class="card shadow-sm border-0 rounded-4">
        <div class="card-body">
            <!-- Buscador simple JS (opcional si DataTables se complica con row-childs nativos) -->
            <div class="mb-3">
                <input type="text" id="buscadorClientes" class="form-control"
                    placeholder="Buscar cliente por nombre, DNI o Patente...">
            </div>

            <div class="table-responsive">
                <table class="table table-hover align-middle w-100" id="tablaClientesSimple">
                    <thead class="bg-light">
                        <tr>
                            <th style="width: 50px;"></th> <!-- Botón + -->
                            <th>NOMBRE</th>
                            <th>DNI/CUIT</th>
                            <th>CELULAR</th>
                            <th>CIUDAD</th>
                            <th class="text-end">ACCIONES</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($clientes as $c):
                            $misVehiculos = $vehiculosPorCliente[$c['id']] ?? [];
                            $collapseId = "collapseClient" . $c['id'];
                            ?>
                            <!-- Fila Principal -->
                            <tr class="cliente-row">
                                <td class="text-center">
                                    <button class="btn btn-sm btn-info text-white btn-toggle-row" type="button"
                                        data-bs-toggle="collapse" data-bs-target="#<?= $collapseId ?>" aria-expanded="false"
                                        aria-controls="<?= $collapseId ?>">
                                        <i class="fas fa-plus"></i>
                                    </button>
                                </td>
                                <td class="fw-bold text-primary">
                                    <?= htmlspecialchars($c['nombres_apellido'] ?? '') ?>
                                    <?php if ($c['cant_vehiculos'] > 0): ?>
                                        <span class="badge-vehiculos" title="<?= $c['cant_vehiculos'] ?> Vehículos">
                                            <?= $c['cant_vehiculos'] ?>
                                        </span>
                                    <?php endif; ?>
                                </td>
                                <td><?= htmlspecialchars($c['cuit_dni'] ?: '-') ?></td>
                                <td><?= htmlspecialchars($c['celular'] ?: '-') ?></td>
                                <td><?= htmlspecialchars($c['ciudad'] ?: '-') ?></td>
                                <td class="text-end">
                                    <button class="btn btn-sm btn-outline-warning"
                                        onclick='editarCliente(<?= json_encode($c) ?>)'>
                                        <i class="fas fa-edit"></i>
                                    </button>
                                </td>
                            </tr>

                            <!-- Fila Desplegable (Vehículos) -->
                            <tr class="collapse bg-light" id="<?= $collapseId ?>">
                                <td colspan="6" class="p-0 border-0">
                                    <div class="p-3 nested-table-container">
                                        <h6 class="fw-bold text-secondary mb-2">
                                            <i class="fas fa-car me-1"></i> Vehículos de
                                            <?= htmlspecialchars($c['nombres_apellido'] ?? '') ?>
                                        </h6>

                                        <?php if (empty($misVehiculos)): ?>
                                            <div class="alert alert-light text-muted border text-center mb-0">
                                                <small>No hay vehículos registrados para este cliente.</small>
                                            </div>
                                        <?php else: ?>
                                            <table class="table table-sm table-bordered bg-white table-vehicles mb-0 shadow-sm">
                                                <thead>
                                                    <tr>
                                                        <th>Patente</th>
                                                        <th>Marca/Modelo</th>
                                                        <th>Año</th>
                                                        <th>Kms</th>
                                                        <th class="text-end">Acciones</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php foreach ($misVehiculos as $v): ?>
                                                        <tr>
                                                            <td>
                                                                <span class="badge bg-dark text-white font-monospace">
                                                                    <?= htmlspecialchars($v['patente'] ?? '') ?>
                                                                </span>
                                                            </td>
                                                            <td><?= htmlspecialchars($v['marca_modelo'] ?? '') ?></td>
                                                            <td><?= htmlspecialchars($v['anio'] ?: '-') ?></td>
                                                            <td><?= htmlspecialchars($v['ultimo_kms'] ?: '0') ?> km</td>
                                                            <td class="text-end">
                                                                <button class="btn btn-sm btn-outline-primary me-1"
                                                                    onclick='openEditVehicle(<?= json_encode($v) ?>)'
                                                                    title="Editar Vehículo">
                                                                    <i class="fas fa-pencil-alt"></i>
                                                                </button>
                                                                <a href="<?= $v['link_historial'] ?>"
                                                                    class="btn btn-sm btn-info text-white" title="Ver Historial">
                                                                    <i class="fas fa-history"></i>
                                                                </a>
                                                            </td>
                                                        </tr>
                                                    <?php endforeach; ?>
                                                </tbody>
                                            </table>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Modal Editar Vehículo -->
<!-- Modal Editar Vehículo movido a includes/modals_globales.php -->

<script>
    // Script para cambiar ícono + / - y buscador simple
    document.addEventListener('DOMContentLoaded', function () {

        // 1. Manejo de íconos en botones collapse
        const collapseButtons = document.querySelectorAll('button[data-bs-toggle="collapse"]');
        collapseButtons.forEach(btn => {
            const targetId = btn.getAttribute('data-bs-target');
            const targetCollapse = document.querySelector(targetId);

            if (targetCollapse) {
                targetCollapse.addEventListener('show.bs.collapse', () => {
                    btn.innerHTML = '<i class="fas fa-minus"></i>';
                    btn.setAttribute('aria-expanded', 'true');
                });

                targetCollapse.addEventListener('hide.bs.collapse', () => {
                    btn.innerHTML = '<i class="fas fa-plus"></i>';
                    btn.setAttribute('aria-expanded', 'false');
                });
            }
        });

        // 2. Buscador simple en tiempo real (Sustituye a Search de DataTables temporalmente para no romper estructura)
        const searchInput = document.getElementById('buscadorClientes');
        searchInput.addEventListener('keyup', function () {
            const term = this.value.toLowerCase();
            const rows = document.querySelectorAll('#tablaClientesSimple tbody tr.cliente-row');

            rows.forEach(row => {
                const text = row.textContent.toLowerCase();
                const collapseId = row.querySelector('button[data-bs-toggle="collapse"]').getAttribute('data-bs-target');
                const collapseRow = document.querySelector(collapseId);

                if (text.includes(term)) {
                    row.style.display = '';
                } else {
                    row.style.display = 'none';
                    // Asegurar que si se oculta el padre, el hijo (si está abierto) no quede "flotando" o visible raro
                    if (collapseRow && collapseRow.classList.contains('show')) {
                        // Opcional: Cerrarlo programáticamente o simplemente ocultarlo
                        // bootstrap.Collapse.getInstance(collapseRow).hide(); 
                        // Pero display none del padre suele ser suficiente en layout, 
                        // aqui ocultamos la fila child manualmente para asegurar
                        collapseRow.style.display = 'none';
                    }
                }

                // Si volvemos a mostrar el padre, asegurarnos de "restaurar" display del hijo si estaba abierto
                if (text.includes(term) && collapseRow) {
                    collapseRow.style.display = ''; // Dejar que la clase collapse/show maneje la visibilidad
                }
            });
        });
    });

    function editarCliente(c) {
        // Asumiendo que existe el modal 'modalEditar' en el footer o global
        // Rellenamos campos con IDs estándar
        if (document.getElementById('edit_id')) document.getElementById('edit_id').value = c.id;
        if (document.getElementById('edit_nombre')) document.getElementById('edit_nombre').value = c.nombres_apellido;
        if (document.getElementById('edit_dni')) document.getElementById('edit_dni').value = c.cuit_dni;
        if (document.getElementById('edit_cel')) document.getElementById('edit_cel').value = c.celular;
        if (document.getElementById('edit_dom')) document.getElementById('edit_dom').value = c.domicilio;
        if (document.getElementById('edit_ciu')) document.getElementById('edit_ciu').value = c.ciudad;
        if (document.getElementById('edit_veh')) document.getElementById('edit_veh').value = c.vehiculo_modelo;

        var modalEl = document.getElementById('modalEditar');
        if (modalEl) {
            var modal = new bootstrap.Modal(modalEl);
            modal.show();
        } else {
            console.error("Modal #modalEditar no encontrado");
        }
    }

    function openEditVehicle(v) {
        document.getElementById('edit_v_id').value = v.id;
        document.getElementById('edit_v_patente').value = v.patente;
        document.getElementById('edit_v_modelo').value = v.marca_modelo;
        document.getElementById('edit_v_anio').value = v.anio;
        document.getElementById('edit_v_kms').value = v.ultimo_kms;
        document.getElementById('edit_v_cliente').value = v.cliente_id;

        var modal = new bootstrap.Modal(document.getElementById('modalEditarVehiculo'));
        modal.show();
    }
</script>

<?php include 'includes/footer.php'; ?>