<?php
// Línea 1 sin espacios para evitar errores de cabecera
session_start();
include 'includes/db.php';

echo "<h1>Reporte de Salud: shtaller-gk</h1>";

// 1. Verificar Tablas Críticas
$tablas_requeridas = [
    'config', 'usuarios', 'clientes', 'gastos', 
    'ordenes_frenos', 'ordenes_motor', 'ordenes_suspension', 'ordenes_otros', 'turnos'
];

echo "<h3>Verificación de Tablas en la Base de Datos:</h3><ul>";

foreach ($tablas_requeridas as $tabla) {
    try {
        $query = $pdo->query("SELECT 1 FROM $tabla LIMIT 1");
        echo "<li style='color:green'>[OK] Tabla: <b>$tabla</b> - Existe y es accesible.</li>";
    } catch (PDOException $e) {
        echo "<li style='color:red'>[ERROR] Tabla: <b>$tabla</b> - NO EXISTE.</li>";
    }
}
echo "</ul>";

// 2. Verificar Conexión y Datos de Configuración
if (isset($config)) {
    echo "<h3>Configuración del Taller:</h3>";
    echo "Conectado al taller: <b>" . ($config['nombre_taller'] ?? 'No definido') . "</b>";
} else {
    echo "<h3 style='color:red'>Error: No se cargó la variable de configuración.</h3>";
}

// 3. Verificar Sesión
echo "<h3>Estado de Sesión:</h3>";
echo "Usuario ID en sesión: " . ($_SESSION['user_id'] ?? 'Ninguno (Sesión no iniciada)');
?>