<?php
// D:\wamp64\www\shtaller-gk\buscar_patente.php
include 'includes/db.php';
header('Content-Type: application/json');

// Forzamos a que PDO devuelva los nombres de columnas en minúsculas
$pdo->setAttribute(PDO::ATTR_CASE, PDO::CASE_LOWER);

$term = isset($_GET['term']) ? trim($_GET['term']) : '';
$type = isset($_GET['search_type']) ? $_GET['search_type'] : 'text';

if (empty($term)) {
    echo json_encode([]);
    exit;
}


try {
    // Consulta optimizada: Traemos último KM real del historial
    $base_sql = "
        SELECT 
            v.id, 
            v.patente, 
            v.marca_modelo as vehiculo_modelo, 
            v.anio,
            (SELECT h.kms FROM view_historial_global h WHERE h.patente = v.patente ORDER BY h.fecha DESC, h.orden_id DESC LIMIT 1) as ultimo_kms, 
            c.id as cliente_id, 
            COALESCE(c.nombres_apellido, 'Sin Cliente') as nombres_apellido 
        FROM vehiculos v
        LEFT JOIN clientes c ON v.cliente_id = c.id
    ";

    if ($type === 'id') {
        // En este caso, busqueda por ID de CLIENTE, devolvemos sus vehículos
        $sql = $base_sql . " WHERE c.id = :term";
        $params = ['term' => $term];
    } else {
        // Busqueda por patente, nombre o modelo de vehiculo
        $sql = $base_sql . " 
            WHERE v.patente LIKE :term1 
               OR c.nombres_apellido LIKE :term2 
               OR v.marca_modelo LIKE :term3
            LIMIT 15
        ";
        $params = [
            'term1' => "%$term%",
            'term2' => "%$term%",
            'term3' => "%$term%"
        ];
    }

    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);
    $results = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode($results);
} catch (PDOException $e) {
    // Log error and return empty
    // error_log("Search error: " . $e->getMessage());
    echo json_encode([]);
}
