<?php
// D:\wamp64\www\shtaller-gk\ayuda.php
session_start();
include 'includes/db.php';
include 'includes/header.php';
?>

<style>
    :root { --sistema-violeta: #5d50c6; }
    
    .help-page { background: #f0f2f5; min-height: 100vh; padding-bottom: 50px; }
    
    /* Estilos de Impresión Profesional */
    @media print {
        .btn, .sidebar, header, footer, .d-print-none { display: none !important; }
        .card { border: none !important; box-shadow: none !important; }
        .help-page { background: white; padding: 0; }
        .markdown-body { font-size: 12pt; }
        .markdown-body img { break-inside: avoid; }
    }

    .help-card { 
        background: white; 
        border-radius: 20px; 
        border: none; 
        overflow: hidden; 
        box-shadow: 0 10px 30px rgba(0,0,0,0.08);
    }
    
    /* Personalización del contenido Markdown */
    .markdown-body { 
        font-family: 'Inter', 'Segoe UI', sans-serif; 
        color: #2d3436; 
        line-height: 1.8; 
    }
    .markdown-body h1 { 
        color: var(--sistema-violeta); 
        font-weight: 800; 
        font-size: 2.5rem;
        border-bottom: 4px solid var(--sistema-violeta); 
        padding-bottom: 15px; 
        margin-bottom: 40px; 
        text-align: center;
    }
    .markdown-body h2 { 
        color: #1a1a1a; 
        border-left: 6px solid var(--sistema-violeta); 
        padding-left: 20px; 
        margin-top: 50px; 
        font-weight: 700; 
        background: #f8f9fa;
        padding-top: 10px;
        padding-bottom: 10px;
    }
    .markdown-body h3 { color: var(--sistema-violeta); margin-top: 30px; font-weight: 700; }
    
    .markdown-body img { 
        max-width: 100%; 
        height: auto; 
        border: 2px solid #eaeff2; 
        border-radius: 15px; 
        margin: 30px 0; 
        display: block;
        box-shadow: 0 15px 35px rgba(0,0,0,0.12); 
    }

    .markdown-body hr { height: 2px; background: #e0e0e0; margin: 40px 0; border: none; }
    
    .markdown-body blockquote {
        background: #f1f0ff;
        border-left: 5px solid var(--sistema-violeta);
        padding: 20px;
        font-style: italic;
        border-radius: 8px;
        margin: 25px 0;
    }

    .markdown-body code { background: #f1f1f1; color: #d63384; padding: 2px 6px; border-radius: 4px; }

    .btn-indigo { background: var(--sistema-violeta); color: white; border: none; padding: 12px 25px; border-radius: 10px; font-weight: 700; transition: 0.3s; }
    .btn-indigo:hover { background: #4a3fb0; color: white; transform: translateY(-2px); box-shadow: 0 5px 15px rgba(93, 80, 198, 0.4); }
</style>

<div class="help-page">
    <div class="container py-5">
        <div class="d-flex justify-content-between align-items-center mb-5 d-print-none">
            <div>
                <h2 class="fw-bold m-0"><i class="fas fa-atlas me-2" style="color: var(--sistema-violeta);"></i> Centro de Documentación</h2>
                <p class="text-muted m-0">Manual de Usuario Integral - Proyecto shtaller.gk</p>
            </div>
            <div class="d-flex gap-2">
                <a href="index.php" class="btn btn-outline-secondary fw-bold px-4">
                    <i class="fas fa-chevron-left me-2"></i> Volver
                </a>
                <button onclick="window.print();" class="btn btn-indigo shadow-sm">
                    <i class="fas fa-file-pdf me-2"></i> GENERAR PDF / IMPRIMIR
                </button>
            </div>
        </div>

        <div class="help-card animate__animated animate__fadeIn">
            <div class="card-body p-4 p-md-5">
                <div id="tutorial-content" class="markdown-body">
                    <div class="text-center py-5">
                        <div class="spinner-border text-primary" style="width: 3rem; height: 3rem;" role="status"></div>
                        <p class="mt-4 text-muted fs-5">Sincronizando con TUTORIAL_MAESTRO.md...</p>
                    </div>
                </div>
            </div>
        </div>

        <div class="text-center mt-5 text-muted small d-print-none">
            <p>© 2026 Taller GK - Sistema de Gestión Interna. Todos los derechos reservados.</p>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/marked/marked.min.js"></script>

<script>
    // Configuramos marked para permitir HTML dentro del Markdown (por los iconos FontAwesome)
    marked.setOptions({
        headerIds: true,
        gfm: true,
        breaks: true
    });

    // Cargamos el archivo MD que Antigravity generó
    fetch('TUTORIAL_MAESTRO.md')
        .then(response => {
            if (!response.ok) throw new Error('No se encontró el archivo del manual.');
            return response.text();
        })
        .then(text => {
            // Inyectamos el contenido transformado a HTML
            document.getElementById('tutorial-content').innerHTML = marked.parse(text);
        })
        .catch(err => {
            document.getElementById('tutorial-content').innerHTML = `
                <div class="text-center py-5">
                    <i class="fas fa-file-excel fa-5x text-danger mb-4"></i>
                    <h3 class="text-danger">Archivo no detectado</h3>
                    <p class="text-muted">Asegúrate de que el archivo <b>TUTORIAL_MAESTRO.md</b> esté en la raíz del proyecto.</p>
                    <hr class="w-25 mx-auto">
                    <button onclick="location.reload()" class="btn btn-outline-primary btn-sm mt-3">Reintentar Carga</button>
                </div>`;
        });
</script>

<?php include 'includes/footer.php'; ?>