document.addEventListener("DOMContentLoaded", function () {
    const inputs = [
        { id: "cliente", type: "cliente", hiddenId: "cliente_id" },
        { id: "vehiculo", type: "vehiculo" },
        { id: "patente", type: "patente" }
    ];

    inputs.forEach(field => {
        const input = document.getElementById(field.id); // Ahora buscamos por ID, asegurarse que los inputs tengan ID
        if (!input) return; // Si no existe el input (ej: id no puesto), saltar

        let list = document.createElement("div");
        list.className = "autocomplete-list list-group position-absolute shadow-sm";
        list.style.zIndex = "1000";
        list.style.display = "none";
        list.style.width = input.offsetWidth + "px"; // Mismo ancho que el input
        list.style.maxHeight = "200px";
        list.style.overflowY = "auto";
        list.style.border = "2px solid #5d50c6"; // Borde estético púrpura
        input.parentNode.appendChild(list);

        // Estilo relativo al padre para posicionamiento absoluto
        if (getComputedStyle(input.parentNode).position === 'static') {
            input.parentNode.style.position = 'relative';
        }

        let debounceTimer;

        input.addEventListener("input", function () {
            const query = this.value;
            clearTimeout(debounceTimer);

            if (query.length < 2) {
                list.style.display = "none";
                return;
            }

            debounceTimer = setTimeout(() => {
                fetch(`buscar_sugerencias.php?tipo=${field.type}&q=${encodeURIComponent(query)}`)
                    .then(response => response.json())
                    .then(data => {
                        list.innerHTML = "";
                        if (data.length > 0) {
                            data.forEach(item => {
                                let itemDiv = document.createElement("button");
                                itemDiv.className = "list-group-item list-group-item-action border-0";
                                itemDiv.style.cursor = "pointer";
                                itemDiv.innerText = item.text;

                                itemDiv.addEventListener("click", function (e) {
                                    e.preventDefault(); // Evitar submit
                                    input.value = item.text;
                                    list.style.display = "none";

                                    // Si es cliente y tenemos ID, guardarlo
                                    if (field.type === 'cliente' && item.id) {
                                        const hiddenInput = document.getElementById(field.hiddenId);
                                        if (hiddenInput) hiddenInput.value = item.id;

                                        // Opcional: Si el backend devolvió datos extra, podríamos llenar otros campos si estuvieran vacíos?
                                        // Por ahora nos limitamos a lo pedido.
                                    }
                                });
                                list.appendChild(itemDiv);
                            });
                        } else {
                            let noMatch = document.createElement("div");
                            noMatch.className = "list-group-item list-group-item-light text-muted small fst-italic";
                            noMatch.innerText = "Sin coincidencias. Se creará nuevo.";
                            list.appendChild(noMatch);
                        }
                        list.style.display = "block";
                    })
                    .catch(err => console.error("Error en autocomplete:", err));
            }, 300);
        });

        // Cerrar lista al hacer clic fuera
        document.addEventListener("click", function (e) {
            if (e.target !== input && e.target !== list) {
                list.style.display = "none";
            }
        });
    });
});
