// D:\wamp64\www\shtaller-gk\assets\js\autocompletado_ordenes.js

/**
 * Abre el historial del vehículo basado en la patente actual
 */
function verHistorialRapido() {
    const patente = document.getElementById("patente").value;
    if (patente.trim() === "") {
        alert("Por favor, ingrese una patente para consultar el historial.");
        return;
    }
    window.open(`historial_vehiculo.php?patente=${patente}`, '_blank');
}

document.addEventListener("DOMContentLoaded", function () {
    const inputPatente = document.getElementById("patente");
    const inputCliente = document.getElementById("cliente");
    const inputClienteId = document.getElementById("cliente_id"); // Hidden ID
    const inputVehiculo = document.getElementById("vehiculo");
    const inputKms = document.getElementById("kms");
    const selCliente = document.getElementById("sel_cliente"); // Legacy support if needed

    // Helper to create list
    function createList(inputElement) {
        let list = document.createElement("div");
        list.className = "list-group position-absolute shadow-lg";
        list.style.cssText = "z-index:2000; display:none; width:100%; top:100%; left:0; background:white; min-width:250px; max-height:300px; overflow-y:auto;";

        const container = inputElement.closest('td') || inputElement.parentNode;
        if (container) {
            container.style.position = 'relative';
            container.appendChild(list);
        }
        return list;
    }

    // Helper to handle selection
    function selectItem(item) {
        // Mapeo seguro de datos
        const patenteVal = item.patente || item.PATENTE || "";
        const modeloVal = item.vehiculo_modelo || item.VEHICULO_MODELO || "";
        const clienteVal = item.nombres_apellido || item.NOMBRES_APELLIDO || "";

        // Manejo de ID: La nueva búsqueda devuelve 'cliente_id'. La vieja devolvía 'id'.
        // Priorizamos cliente_id.
        const clienteIdVal = item.cliente_id || item.CLIENTE_ID || item.id || item.ID || "";

        const kmsVal = item.ultimo_kms || item.ULTIMO_KMS || "0";

        // Llenar campos si existen
        if (inputPatente) inputPatente.value = patenteVal;
        if (inputVehiculo) inputVehiculo.value = modeloVal;
        if (inputCliente) inputCliente.value = clienteVal;
        if (inputClienteId) inputClienteId.value = clienteIdVal;
        if (inputKms) inputKms.value = kmsVal;

        // Actualizar el SELECT de cliente si existe
        if (selCliente) {
            selCliente.value = clienteIdVal;
            // No disparamos el evento change para evitar que se sobrescriba el vehículo 
            // con el "default" del cliente.
        }
    }

    // --- 1. CONFIGURACIÓN AUTOCOMPLETE PATENTE ---
    if (inputPatente) {
        const listPatente = createList(inputPatente);

        inputPatente.addEventListener("input", function () {
            const query = this.value;
            if (query.length < 2) { listPatente.style.display = "none"; return; }

            fetch(`buscar_patente.php?term=${encodeURIComponent(query)}`)
                .then(res => res.json())
                .then(data => {
                    listPatente.innerHTML = "";
                    if (data.length === 0) {
                        listPatente.style.display = "none";
                        return;
                    }

                    data.forEach(item => {
                        const patenteVal = item.patente || item.PATENTE || "S/P";
                        const modeloVal = item.vehiculo_modelo || item.VEHICULO_MODELO || "";
                        const clienteVal = item.nombres_apellido || item.NOMBRES_APELLIDO || "";

                        let btn = document.createElement("button");
                        btn.type = "button";
                        btn.className = "list-group-item list-group-item-action text-start";
                        btn.innerHTML = `<strong>${patenteVal}</strong> - ${modeloVal} <br><small class="text-muted">${clienteVal}</small>`;

                        btn.onclick = (e) => {
                            e.preventDefault();
                            selectItem(item);
                            listPatente.style.display = "none";
                        };
                        listPatente.appendChild(btn);
                    });
                    listPatente.style.display = "block";
                })
                .catch(err => console.error("Error fetching patente:", err));
        });

        // Cerrar al click afuera
        document.addEventListener("click", (e) => {
            if (!inputPatente.contains(e.target)) listPatente.style.display = "none";
        });
    }

    // --- 2. CONFIGURACIÓN AUTOCOMPLETE CLIENTE (NOMBRE) ---
    if (inputCliente) {
        const listCliente = createList(inputCliente);

        inputCliente.addEventListener("input", function () {
            const query = this.value;
            // Permitir buscar desde 3 caracteres para nombres
            if (query.length < 3) { listCliente.style.display = "none"; return; }

            // Usamos el mismo backend 'buscar_patente.php' que ya busca por nombre OR patente
            fetch(`buscar_patente.php?term=${encodeURIComponent(query)}`)
                .then(res => res.json())
                .then(data => {
                    listCliente.innerHTML = "";
                    if (data.length === 0) {
                        listCliente.style.display = "none";
                        return;
                    }

                    data.forEach(item => {
                        const clienteVal = item.nombres_apellido || item.NOMBRES_APELLIDO || "S/N";
                        const patenteVal = item.patente || item.PATENTE || "";
                        const modeloVal = item.vehiculo_modelo || item.VEHICULO_MODELO || "";

                        let btn = document.createElement("button");
                        btn.type = "button";
                        btn.className = "list-group-item list-group-item-action text-start";
                        btn.innerHTML = `<strong>${clienteVal}</strong> <br><small class="text-muted">${patenteVal} - ${modeloVal}</small>`;

                        btn.onclick = (e) => {
                            e.preventDefault();
                            selectItem(item);
                            listCliente.style.display = "none";
                        };
                        listCliente.appendChild(btn);
                    });
                    listCliente.style.display = "block";
                })
                .catch(err => console.error("Error fetching cliente:", err));
        });

        document.addEventListener("click", (e) => {
            if (!inputCliente.contains(e.target)) listCliente.style.display = "none";
        });
    }

    // --- 3. AUTOCOMPLETADO POR SELECTOR (LEGACY / SI EXISTE) ---
    if (selCliente) {
        selCliente.addEventListener("change", function () {
            const id = this.value;
            if (!id) return;

            fetch(`buscar_patente.php?term=${id}&search_type=id`)
                .then(res => res.json())
                .then(data => {
                    if (data.length > 0) {
                        selectItem(data[0]);
                    }
                });
        });
    }

    // --- 4. LÓGICA DEL MODAL "BUSCAR VEHÍCULO" ---
    const modalBuscar = document.getElementById('modalBuscarVehiculo');
    const inputBusqueda = document.getElementById('inputBusquedaVehiculo');
    const tablaResultados = document.querySelector('#tablaResultadosVehiculo tbody');
    let searchTimeout;

    if (modalBuscar && inputBusqueda && tablaResultados) {
        // Al abrir el modal, enfocar el input
        modalBuscar.addEventListener('shown.bs.modal', () => {
            inputBusqueda.value = '';
            tablaResultados.innerHTML = '';
            inputBusqueda.focus();
        });

        // Búsqueda en tiempo real con debounce
        inputBusqueda.addEventListener('input', function () {
            clearTimeout(searchTimeout);
            const term = this.value.trim();

            if (term.length < 2) {
                tablaResultados.innerHTML = '';
                return;
            }

            searchTimeout = setTimeout(() => {
                fetch(`buscar_patente.php?term=${encodeURIComponent(term)}`)
                    .then(res => res.json())
                    .then(data => {
                        tablaResultados.innerHTML = '';
                        if (data.length === 0) {
                            tablaResultados.innerHTML = `
                                <tr>
                                    <td colspan="4" class="text-center py-4">
                                        <div class="mb-3">
                                            <span class="fa-stack fa-2x text-muted opacity-50">
                                                <i class="fas fa-car fa-stack-1x"></i>
                                                <i class="fas fa-ban fa-stack-2x" style="color:tomato"></i>
                                            </span>
                                        </div>
                                        <h5 class="text-muted fw-bold">Vehículo No Encontrado</h5>
                                        <div class="d-grid gap-2 col-8 mx-auto mt-3">
                                            <button type="button" class="btn btn-primary fw-bold shadow-sm" id="btnAbrirModalNuevoCliente">
                                                <i class="fas fa-user-plus me-2"></i> REGISTRAR NUEVO VEHÍCULO/CLIENTE
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                            `;

                            // Handler para Nuevo Cliente
                            const btnNuevoCliente = document.getElementById('btnAbrirModalNuevoCliente');
                            if (btnNuevoCliente) {
                                btnNuevoCliente.addEventListener('click', () => {
                                    // Cerrar modal búsqueda
                                    const modalBusquedaEl = document.getElementById('modalBuscarVehiculo');
                                    const modalBusqueda = bootstrap.Modal.getInstance(modalBusquedaEl);
                                    if (modalBusqueda) modalBusqueda.hide();

                                    // Abrir modal de nuevo cliente (global en footer.php)
                                    const modalCliente = new bootstrap.Modal(document.getElementById('modalNuevo'));
                                    modalCliente.show();

                                    // Intentar pre-llenar patente si el termino parece patente
                                    const inputPatente = document.querySelector('#modalNuevo input[name="patente"]');
                                    if (inputPatente && term.length >= 5) {
                                        inputPatente.value = term.toUpperCase();
                                    }
                                });
                            }
                            return;
                        }

                        data.forEach(item => {
                            const tr = document.createElement('tr');
                            // Valores seguros
                            const patente = item.patente || item.PATENTE || "S/P";
                            const vehiculo = item.vehiculo_modelo || item.VEHICULO_MODELO || "";
                            const cliente = item.nombres_apellido || item.NOMBRES_APELLIDO || "";

                            tr.innerHTML = `
                                <td class="fw-bold text-primary">${patente}</td>
                                <td>${vehiculo}</td>
                                <td>${cliente}</td>
                                <td class="text-end">
                                    <button type="button" class="btn btn-sm btn-success rounded-pill px-3">
                                        <i class="fas fa-check me-1"></i> Cargar
                                    </button>
                                </td>
                            `;

                            // Evento de selección
                            const btnCargar = tr.querySelector('button');
                            btnCargar.onclick = () => {
                                selectItem(item); // Reutiliza la función existente
                                // Cerrar modal (usando Bootstrap 5 API si es posible, o click en cerrar)
                                const closeBtn = modalBuscar.querySelector('[data-bs-dismiss="modal"]');
                                if (closeBtn) closeBtn.click();
                            };

                            tablaResultados.appendChild(tr);
                        });
                    })
                    .catch(err => console.error("Error en búsqueda modal:", err));
            }, 300); // 300ms delay
        });
    }

    // --- 5. LÓGICA DEL FORMULARIO NUEVO CLIENTE (Interceptar para AJAX) ---
    // Esto es nuevo: permitimos que el modal de "Nuevo Cliente" funcione via AJAX si estamos en la orden
    const formNuevoCliente = document.querySelector('#modalNuevo form');
    if (formNuevoCliente) {
        formNuevoCliente.addEventListener('submit', function (e) {
            // Solo interceptamos si estamos en una página de orden (verificamos existencia de inputs clave)
            if (!document.getElementById('cliente_id')) return;

            e.preventDefault();
            const formData = new FormData(this);
            formData.append('ajax', '1'); // Forzar respuesta JSON

            fetch('procesar_cliente.php', {
                method: 'POST',
                body: formData
            })
                .then(res => res.json())
                .then(data => {
                    if (data.status === 'ok') {
                        // Cerrar modal
                        const modalNuevoEl = document.getElementById('modalNuevo');
                        const modalNuevoInstance = bootstrap.Modal.getInstance(modalNuevoEl);
                        if (modalNuevoInstance) modalNuevoInstance.hide();

                        // Construir objeto item compatible con selectItem
                        // La data devuelta por procesar_cliente debe incluir patente y modelo
                        const item = {
                            cliente_id: data.data.id,
                            nombres_apellido: data.data.nombres_apellido,
                            patente: data.data.patente || formData.get('patente'),
                            vehiculo_modelo: data.data.vehiculo_modelo || formData.get('vehiculo_modelo'),
                            ultimo_kms: 0
                        };

                        selectItem(item);
                        alert("Cliente y Vehículo registrados correctamente.");

                        // Limpiar formulario
                        formNuevoCliente.reset();
                    } else {
                        alert('Error: ' + data.message);
                    }
                })
                .catch(err => {
                    console.error("Error saving client via AJAX:", err);
                    alert("Error al procesar la solicitud.");
                });
        });
    }

    // --- 6. LÓGICA DEL FORMULARIO NUEVO VEHÍCULO (EXISTENTE - MANTENIDA POR COMPATIBILIDAD) ---
    const formNuevo = document.getElementById('formNuevoVehiculo');
    if (formNuevo) {
        formNuevo.addEventListener('submit', function (e) {
            e.preventDefault();
            const formData = new FormData(this);

            fetch('ajax/guardar_vehiculo.php', {
                method: 'POST',
                body: formData
            })
                .then(res => res.json())
                .then(data => {
                    if (data.status === 'ok') {
                        // 1. Seleccionar el nuevo vehículo en el formulario principal
                        selectItem(data.data); // data.data tiene la estructura compatible

                        // 2. Cerrar modales
                        const modalNuevoEl = document.getElementById('modalNuevoVehiculo');
                        const modalNuevoInstance = bootstrap.Modal.getInstance(modalNuevoEl);
                        if (modalNuevoInstance) modalNuevoInstance.hide();

                        const modalBuscarEl = document.getElementById('modalBuscarVehiculo');
                        const modalBuscarInstance = bootstrap.Modal.getInstance(modalBuscarEl);
                        if (modalBuscarInstance) modalBuscarInstance.hide();

                        alert('Vehículo registrado y seleccionado correctamente.');
                    } else {
                        alert('Error al guardar: ' + data.message);
                    }
                })
                .catch(err => console.error("Error saving vehicle:", err));
        });
    }

});