// DataTables Initialization
$(document).ready(function () {
    // Inicialización de DataTables para cualquier tabla con la clase .datatable-auto
    if ($('.datatable-auto').length) {
        var table = $('.datatable-auto').DataTable({
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.13.6/i18n/es-ES.json"
            },
            "dom": 't', // Oculta el buscador por defecto de DataTables para usar el del Header
            "paging": false,
            "info": false
        });

        // Vincular el buscador del Header con la tabla
        $('#globalSearch').on('keyup', function () {
            table.search(this.value).draw();
        });
    }
});

// Cálculo de Subtotales (para Motor, Suspension, Otros)
// Cálculo de Subtotales (Universal)
function calcularTotales() {
    let sub1 = 0;
    let sub2 = 0;

    document.querySelectorAll('.price-input').forEach(i => sub1 += Number(i.value) || 0);
    document.querySelectorAll('.price-input-2').forEach(i => sub2 += Number(i.value) || 0);

    if (document.getElementById('subtotal1')) document.getElementById('subtotal1').value = sub1.toFixed(2);
    if (document.getElementById('subtotal2')) document.getElementById('subtotal2').value = sub2.toFixed(2);
    if (document.getElementById('total_general')) document.getElementById('total_general').value = (sub1 + sub2).toFixed(2);
}

document.addEventListener('DOMContentLoaded', calcularTotales);
document.addEventListener('input', function (e) {
    if (e.target.classList.contains('price-input') || e.target.classList.contains('price-input-2')) {
        calcularTotales();
    }
});

// Excel Export (para hoja_de_servicio.php)
function exportToExcel() {
    if (typeof XLSX === 'undefined') {
        alert('Librería SheetJS no cargada.');
        return;
    }
    // Escanear datos de tabla
    var data = [['ITEM DE SERVICIO', 'REALIZADO (Si/No)', 'IMPORTE ($)']];
    var rows = document.querySelectorAll('.table-items tbody tr');

    rows.forEach(function (r) {
        var cols = r.querySelectorAll('td');
        if (cols.length >= 3) {
            // Eliminar espacios y saltos extra
            var item = cols[0].innerText.trim();
            var check = cols[1].innerText.trim();
            var price = cols[2].innerText.trim();

            // Solo agregar si el item tiene texto
            if (item !== "") {
                data.push([item, check, price]);
            }
        }
    });

    // Crear libro
    var wb = XLSX.utils.book_new();
    var ws = XLSX.utils.aoa_to_sheet(data);

    // Ajustar anchos
    ws['!cols'] = [{ wch: 50 }, { wch: 15 }, { wch: 15 }];

    // Obtener categoria si existe en el DOM o usar default
    var cat = "General";
    // Intentar leer del input hidden o url si fuera posible, pero aqui hardcodeamos o leemos del titulo?
    // Mejor dejamos HojaServicio por defecto
    XLSX.utils.book_append_sheet(wb, ws, "HojaServicio");
    XLSX.writeFile(wb, "Hoja_Servicio.xlsx");
}
