<?php
// ajax/guardar_vehiculo.php
include '../includes/db.php';
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['status' => 'error', 'message' => 'Método no permitido']);
    exit;
}

$patente = isset($_POST['patente']) ? strtoupper(trim($_POST['patente'])) : '';
$modelo = isset($_POST['marca_modelo']) ? trim($_POST['marca_modelo']) : '';
$cliente_id = isset($_POST['cliente_id']) ? intval($_POST['cliente_id']) : 0;
$anio = isset($_POST['anio']) ? intval($_POST['anio']) : null;

if (empty($patente) || empty($modelo) || $cliente_id <= 0) {
    echo json_encode(['status' => 'error', 'message' => 'Faltan datos obligatorios (Patente, Modelo o Cliente)']);
    exit;
}

try {
    // Verificar si la patente ya existe
    $stmtCheck = $pdo->prepare("SELECT id FROM vehiculos WHERE patente = ?");
    $stmtCheck->execute([$patente]);
    if ($stmtCheck->fetch()) {
        echo json_encode(['status' => 'error', 'message' => 'La patente ya está registrada.']);
        exit;
    }

    // Insertar nuevo vehículo
    $sql = "INSERT INTO vehiculos (cliente_id, patente, marca_modelo, anio, fecha_actualizacion, ultimo_kms) 
            VALUES (:cliente_id, :patente, :modelo, :anio, NOW(), :kms)";

    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        ':cliente_id' => $cliente_id,
        ':patente' => $patente,
        ':modelo' => $modelo,
        ':anio' => $anio,
        ':kms' => '0' // Default initial kms
    ]);

    $newId = $pdo->lastInsertId();

    // Obtener datos del cliente para devolver al front
    $stmtC = $pdo->prepare("SELECT nombres_apellido FROM clientes WHERE id = ?");
    $stmtC->execute([$cliente_id]);
    $clienteName = $stmtC->fetchColumn();

    $responseData = [
        'id' => $newId,
        'patente' => $patente,
        'vehiculo_modelo' => $modelo,
        'cliente_id' => $cliente_id,
        'nombres_apellido' => $clienteName,
        'ultimo_kms' => '0'
    ];

    echo json_encode(['status' => 'ok', 'data' => $responseData]);

} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => 'Error BD: ' . $e->getMessage()]);
}
?>