<?php
include '../includes/db.php';

header('Content-Type: application/json; charset=utf-8');

$id = isset($_GET['id']) ? intval($_GET['id']) : 0;

$data = [
    "vehiculo_modelo" => "",
    "patente" => "",
    "kms" => ""
];

if ($id > 0) {
    try {
        // Buscamos el último dato registrado en CUALQUIERA de las tablas de órdenes
        // Ya que la tabla 'clientes' no guarda vehículo/patente, y 'ordenes_trabajo' podría no estar sincronizada
        $sql = "
            SELECT vehiculo, patente, kms, fecha 
            FROM (
                SELECT vehiculo, patente, kms, fecha FROM ordenes_frenos WHERE cliente_id = :id1
                UNION ALL
                SELECT vehiculo, patente, kms, fecha FROM ordenes_motor WHERE cliente_id = :id2
                UNION ALL
                SELECT vehiculo, patente, kms, fecha FROM ordenes_suspension WHERE cliente_id = :id3
                UNION ALL
                SELECT vehiculo, patente, kms, fecha FROM ordenes_otros WHERE cliente_id = :id4
            ) as historial
            ORDER BY fecha DESC, kms DESC
            LIMIT 1
        ";

        $stmt = $pdo->prepare($sql);
        $stmt->execute([':id1' => $id, ':id2' => $id, ':id3' => $id, ':id4' => $id]);

        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($row) {
            $data['vehiculo_modelo'] = $row['vehiculo'];
            $data['patente'] = $row['patente'];
            $data['kms'] = $row['kms'];
        }

    } catch (PDOException $e) {
        // En producción, loguear el error. Aquí devolvemos vacío para no romper el cliente
        // error_log("Error en get_cliente_data: " . $e->getMessage());
    }
}

echo json_encode($data);
?>