<?php
session_start();
// Seguridad: solo administradores
if (!isset($_SESSION['user_id']) || $_SESSION['rol'] !== 'admin') {
    header("Location: index.php");
    exit;
}
include 'includes/db.php';
include 'includes/header.php';

// 1. Obtener datos de la empresa
$stmt_cfg = $pdo->query("SELECT * FROM configuracion WHERE id = 1");
$config = $stmt_cfg->fetch();

// 2. Obtener lista de usuarios
$stmt_users = $pdo->query("SELECT * FROM usuarios ORDER BY apellidos ASC");
$usuarios = $stmt_users->fetchAll();
?>

<div class="p-4" style="position: relative; z-index: 1;">

    <div class="card shadow-sm border-0 rounded-4 mb-4" style="border-left: 5px solid #5d50c6 !important;">
        <div class="card-body p-4">
            <div class="row align-items-center">
                <div class="col-md-2 text-center border-end">
                    <img src="<?= $config['logo_path'] ?: 'assets/img/logo_default.png' ?>" alt="Logo" class="img-fluid"
                        style="max-height: 80px;">
                </div>
                <div class="col-md-7 ps-4">
                    <h4 class="fw-bold mb-1"><?= htmlspecialchars($config['nombre_taller']) ?></h4>
                    <p class="text-muted mb-0 small">
                        <i class="fas fa-id-card me-1"></i> CUIT: <?= htmlspecialchars($config['cuit']) ?> |
                        <i class="fas fa-file-invoice-dollar me-1"></i>
                        <?= htmlspecialchars($config['iva_condicion']) ?>
                    </p>
                    <p class="text-muted mb-0 small">
                        <i class="fas fa-map-marker-alt me-1"></i> <?= htmlspecialchars($config['domicilio']) ?> |
                        <i class="fas fa-phone me-1"></i> <?= htmlspecialchars($config['telefono']) ?>
                    </p>
                </div>
                <div class="col-md-3 text-end">
                    <a href="configuracion.php" class="btn btn-outline-secondary btn-sm rounded-pill">
                        <i class="fas fa-cog me-1"></i> Editar Datos
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="fw-bold text-dark m-0">
            <i class="fas fa-user-shield me-2" style="color: #5d50c6;"></i> Usuarios del Sistema
        </h3>
        <button class="btn btn-primary px-4 fw-bold" data-bs-toggle="modal" data-bs-target="#modalNuevoUsuario">
            <i class="fas fa-plus-circle me-1"></i> NUEVO USUARIO
        </button>
    </div>

    <div class="card shadow-sm border-0 rounded-4">
        <div class="card-body p-0">
            <table class="table table-hover align-middle mb-0">
                <thead class="bg-light">
                    <tr class="text-uppercase small fw-bold text-muted">
                        <th class="px-4 py-3">Personal</th>
                        <th>Usuario</th>
                        <th>Rol</th>
                        <th>Estado</th>
                        <th class="text-end px-4">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($usuarios as $u): ?>
                        <tr>
                            <td class="px-4 fw-bold"><?= htmlspecialchars($u['apellidos'] . ", " . $u['nombres']) ?></td>
                            <td class="text-muted"><?= htmlspecialchars($u['usuario']) ?></td>
                            <td><span class="badge bg-light text-dark border"><?= strtoupper($u['rol']) ?></span></td>
                            <td>
                                <span class="badge <?= $u['estado'] == 1 ? 'bg-success' : 'bg-danger' ?>">
                                    <?= $u['estado'] == 1 ? 'ACTIVO' : 'INACTIVO' ?>
                                </span>
                            </td>
                            <td class="text-end px-4">
                                <button class="btn btn-sm btn-outline-dark" onclick='abrirPass(<?= $u['id'] ?>)'
                                    title="Contraseña">
                                    <i class="fas fa-key"></i>
                                </button>
                                <button class="btn btn-sm btn-outline-primary mx-1"
                                    onclick='editarUser(<?= json_encode($u) ?>)' title="Editar">
                                    <i class="fas fa-edit"></i>
                                </button>
                                <a href="procesar_usuario.php?accion=status&id=<?= $u['id'] ?>"
                                    class="btn btn-sm <?= $u['estado'] == 1 ? 'btn-outline-danger' : 'btn-outline-success' ?>">
                                    <i class="fas <?= $u['estado'] == 1 ? 'fa-user-slash' : 'fa-user-check' ?>"></i>
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
    function editarUser(u) {
        document.getElementById('edit_u_id').value = u.id;
        document.getElementById('edit_u_nombres').value = u.nombres;
        document.getElementById('edit_u_apellidos').value = u.apellidos;
        document.getElementById('edit_u_login').value = u.usuario;
        document.getElementById('edit_u_rol').value = u.rol;
        document.getElementById('edit_u_estado').value = u.estado;

        new bootstrap.Modal(document.getElementById('modalEditarUsuario')).show();
    }

    function abrirPass(id) {
        document.getElementById('pass_u_id').value = id;
        new bootstrap.Modal(document.getElementById('modalPassUsuario')).show();
    }
</script>

<?php include 'includes/footer.php'; ?>