<?php
// D:\wamp64\www\shtaller-gk\actualizar_cliente.php
session_start();

// 1. Verificación de seguridad
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

include 'includes/db.php';

// 2. Comprobar que los datos vienen por POST
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    
    // Captura de datos del formulario
    $id = $_POST['id'];
    $nombre = $_POST['nombres_apellido'];
    $dni = $_POST['cuit_dni'];
    $celular = $_POST['celular'];
    $domicilio = $_POST['domicilio'];
    $ciudad = $_POST['ciudad'];
    $patente = strtoupper(trim($_POST['patente'])); // Guardamos siempre en MAYÚSCULAS
    $vehiculo = $_POST['vehiculo_modelo'];

    try {
        // 3. Preparar la consulta de actualización
        $sql = "UPDATE clientes SET 
                nombres_apellido = :nombre, 
                cuit_dni = :dni, 
                celular = :celular, 
                domicilio = :domicilio, 
                ciudad = :ciudad, 
                patente = :patente, 
                vehiculo_modelo = :vehiculo 
                WHERE id = :id";

        $stmt = $pdo->prepare($sql);

        // 4. Ejecutar con los parámetros
        $resultado = $stmt->execute([
            ':nombre'   => $nombre,
            ':dni'      => $dni,
            ':celular'  => $celular,
            ':domicilio'=> $domicilio,
            ':ciudad'   => $ciudad,
            ':patente'  => $patente,
            ':vehiculo' => $vehiculo,
            ':id'       => $id
        ]);

        if ($resultado) {
            // Éxito: Redirigir con parámetro de estado
            header("Location: clientes.php?status=updated");
        } else {
            header("Location: clientes.php?status=error");
        }

    } catch (PDOException $e) {
        // En caso de error (ej: patente duplicada si tienes índice UNIQUE)
        die("Error crítico al actualizar el cliente: " . $e->getMessage());
    }
} else {
    // Si alguien intenta entrar directamente al archivo sin enviar el formulario
    header("Location: clientes.php");
}
exit;